/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.worldeditslimefun.commands.flags;

import dev.j3fftw.worldeditslimefun.acf.BukkitCommandCompletionContext;
import dev.j3fftw.worldeditslimefun.commands.flags.CommandFlag;
import dev.j3fftw.worldeditslimefun.tasks.RefillInputsTask;
import dev.j3fftw.worldeditslimefun.tasks.VoidOutputsTask;
import dev.j3fftw.worldeditslimefun.utils.Utils;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CommandFlags {
    private static final Map<String, CommandFlag<?>> FLAG_TYPES = new HashMap<String, TimeoutFlag>(Map.of("--energy", new EnergyFlag(), "--inputs", new InputsFlag(), "--refill_inputs_task", new RefillInputsFlag(), "--void_outputs_task", new VoidOutputsFlag(), "--task_timeout", new TimeoutFlag()));

    @Nullable
    public static CommandFlag<?> getFlag(@Nonnull String type, @Nonnull String value) {
        CommandFlag<?> flag = FLAG_TYPES.get(type);
        if (flag != null) {
            return flag.ofValue(value);
        }
        return null;
    }

    @Nonnull
    public static List<CommandFlag<?>> getFlags(@Nonnull List<String> args) {
        ArrayList flags = new ArrayList();
        for (int i = 0; i < args.size(); ++i) {
            CommandFlag<?> flag;
            String arg = args.get(i);
            if (!FLAG_TYPES.containsKey(arg) || (flag = CommandFlags.getFlag(arg, args.get(i + 1))) == null) continue;
            flags.add(flag);
        }
        return flags;
    }

    public static boolean addFlagType(@Nonnull String type, @Nonnull CommandFlag<?> flag) {
        if (FLAG_TYPES.containsKey(type)) {
            return false;
        }
        FLAG_TYPES.put(type, flag);
        return true;
    }

    @Nonnull
    public static Map<String, CommandFlag<?>> getFlagTypes() {
        return Map.copyOf(FLAG_TYPES);
    }

    public static class EnergyFlag
    extends CommandFlag<Boolean> {
        @Override
        public void apply(Player player, List<CommandFlag<?>> flags, SlimefunItem sfItem, Block block) {
            BlockStorage.addBlockInfo((Block)block, (String)"energy-charge", (String)String.valueOf(Integer.MAX_VALUE), (boolean)false);
        }

        @Override
        public boolean canApply(SlimefunItem sfItem) {
            EnergyNetComponent component;
            return this.value != null && (Boolean)this.value != false && sfItem instanceof EnergyNetComponent && (component = (EnergyNetComponent)sfItem).isChargeable();
        }

        @Override
        public Collection<String> getTabSuggestions(BukkitCommandCompletionContext context) {
            return List.of("true", "false");
        }

        public EnergyFlag ofValue(String value) {
            return (EnergyFlag)new EnergyFlag().setValue(Boolean.parseBoolean(value));
        }
    }

    public static class InputsFlag
    extends CommandFlag<List<ItemStack>> {
        @Override
        public void apply(Player player, List<CommandFlag<?>> flags, SlimefunItem sfItem, Block block) {
            ItemStack input;
            BlockMenu menu = BlockStorage.getInventory((Block)block);
            int[] slots = menu.getPreset().getSlotsAccessedByItemTransport(ItemTransportFlow.INSERT);
            Iterator iterator = ((List)this.value).iterator();
            while (iterator.hasNext() && menu.pushItem(new ItemStack(input = (ItemStack)iterator.next()), slots) == null) {
            }
        }

        @Override
        public boolean canApply(SlimefunItem sfItem) {
            return this.value != null && !((List)this.value).isEmpty() && Slimefun.getRegistry().getMenuPresets().containsKey(sfItem.getId());
        }

        @Override
        public Collection<String> getTabSuggestions(BukkitCommandCompletionContext context) {
            String input = context.getInput();
            if (input.isEmpty()) {
                return List.of("[");
            }
            char lastChar = input.charAt(input.length() - 1);
            if (lastChar == ']') {
                return Collections.emptyList();
            }
            ArrayList<String> inputs = new ArrayList<String>();
            if (lastChar == ',') {
                inputs.addAll(this.generateBaseInputs(input, context.getPlayer().getWorld()));
            } else {
                String current = input.contains(",") ? input.substring(input.lastIndexOf(",") + 1) : input.substring(input.indexOf(91) + 1);
                if (Utils.SLIMEFUN_ITEMS.contains(current = current.toUpperCase(Locale.ROOT)) || Utils.MATERIALS.containsKey(current)) {
                    inputs.add(input + "]");
                    inputs.addAll(this.generateBaseInputs(input + ",", context.getPlayer().getWorld()));
                    return inputs;
                }
                String base = input.substring(0, input.length() - current.length());
                for (String slimefunItem : Utils.SLIMEFUN_ITEMS) {
                    if (!slimefunItem.startsWith(current)) continue;
                    inputs.add(base + slimefunItem);
                }
                World world = context.getPlayer().getWorld();
                for (Material material : Utils.MATERIALS.values()) {
                    String name = material.name();
                    if (!material.isEnabledByFeature(world) || !name.startsWith(current)) continue;
                    inputs.add(base + name);
                }
            }
            return inputs;
        }

        private Collection<String> generateBaseInputs(String input, World world) {
            ArrayList<String> inputs = new ArrayList<String>();
            for (String slimefunItem : Utils.SLIMEFUN_ITEMS) {
                inputs.add(input + slimefunItem + ",");
            }
            for (Material material : Utils.MATERIALS.values()) {
                if (!material.isEnabledByFeature(world)) continue;
                inputs.add(input + material.name() + ",");
            }
            return inputs;
        }

        public InputsFlag ofValue(String value) {
            String[] segments = value.substring(1, value.length() - 1).split(",");
            ArrayList<Object> inputs = new ArrayList<Object>();
            for (String input : segments) {
                input = input.toUpperCase(Locale.ROOT);
                SlimefunItem slimefunItem = SlimefunItem.getById((String)input);
                Material material = Utils.MATERIALS.get(input);
                if (slimefunItem != null) {
                    inputs.add(new CustomItemStack(slimefunItem.getItem(), slimefunItem.getItem().getMaxStackSize()));
                    continue;
                }
                if (material == null) continue;
                inputs.add(new ItemStack(material, material.getMaxStackSize()));
            }
            return (InputsFlag)new InputsFlag().setValue(inputs);
        }
    }

    public static class RefillInputsFlag
    extends CommandFlag<Boolean> {
        private RefillInputsTask task;

        @Override
        public void apply(Player player, List<CommandFlag<?>> flags, SlimefunItem sfItem, Block block) {
            if (this.task == null) {
                this.task = new RefillInputsTask(sfItem);
                for (CommandFlag<?> otherFlag : flags) {
                    if (otherFlag instanceof TimeoutFlag) {
                        TimeoutFlag timeoutFlag = (TimeoutFlag)otherFlag;
                        this.task.setTimeout((Integer)timeoutFlag.getValue());
                        continue;
                    }
                    if (!(otherFlag instanceof InputsFlag)) continue;
                    InputsFlag inputsFlag = (InputsFlag)otherFlag;
                    this.task.setInputs((List)inputsFlag.getValue());
                }
            }
            this.task.addBlock(block);
        }

        @Override
        public boolean canApply(SlimefunItem sfItem) {
            return this.value != null && (Boolean)this.value != false && Slimefun.getRegistry().getMenuPresets().containsKey(sfItem.getId());
        }

        @Override
        public Collection<String> getTabSuggestions(BukkitCommandCompletionContext context) {
            return List.of("true", "false");
        }

        public RefillInputsFlag ofValue(String value) {
            return (RefillInputsFlag)new RefillInputsFlag().setValue(Boolean.parseBoolean(value));
        }
    }

    public static class VoidOutputsFlag
    extends CommandFlag<Boolean> {
        private VoidOutputsTask task;

        @Override
        public void apply(Player player, List<CommandFlag<?>> flags, SlimefunItem sfItem, Block block) {
            if (this.task == null) {
                this.task = new VoidOutputsTask(sfItem);
                for (CommandFlag<?> otherFlag : flags) {
                    if (!(otherFlag instanceof TimeoutFlag)) continue;
                    TimeoutFlag timeoutFlag = (TimeoutFlag)otherFlag;
                    this.task.setTimeout((Integer)timeoutFlag.getValue());
                }
            }
            this.task.addBlock(block);
        }

        @Override
        public boolean canApply(SlimefunItem sfItem) {
            return this.value != null && (Boolean)this.value != false && Slimefun.getRegistry().getMenuPresets().containsKey(sfItem.getId());
        }

        @Override
        public Collection<String> getTabSuggestions(BukkitCommandCompletionContext context) {
            return List.of("true", "false");
        }

        public VoidOutputsFlag ofValue(String value) {
            return (VoidOutputsFlag)new VoidOutputsFlag().setValue(Boolean.parseBoolean(value));
        }
    }

    public static class TimeoutFlag
    extends CommandFlag<Integer> {
        @Override
        public void apply(Player player, List<CommandFlag<?>> flags, SlimefunItem sfItem, Block block) {
        }

        @Override
        public boolean canApply(SlimefunItem sfItem) {
            return sfItem != null && this.value != null && (Integer)this.value > 0;
        }

        @Override
        public Collection<String> getTabSuggestions(BukkitCommandCompletionContext context) {
            return List.of("30s", "5m", "1h");
        }

        public TimeoutFlag ofValue(String value) {
            int multiplier = switch (value.charAt(value.length() - 1)) {
                case 's' -> 20;
                case 'm' -> 1200;
                case 'h' -> 72000;
                default -> 0;
            };
            return (TimeoutFlag)new TimeoutFlag().setValue(multiplier * Integer.parseInt(value.substring(0, value.length() - 1)));
        }
    }
}

