/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.worldeditslimefun.tasks;

import dev.j3fftw.worldeditslimefun.WorldEditSlimefun;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import java.util.HashSet;
import java.util.Set;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class AbstractTask
extends BukkitRunnable {
    protected final SlimefunItem sfItem;
    protected final Set<BlockPosition> blocks = new HashSet<BlockPosition>();
    protected int timeout = 6000;
    protected int ticks = 0;

    public AbstractTask(SlimefunItem sfItem) {
        this.sfItem = sfItem;
    }

    public final void run() {
        if (this.blocks.isEmpty()) {
            this.cancel();
            return;
        }
        if (this.ticks >= this.timeout) {
            this.cancel();
            return;
        }
        for (BlockPosition position : new HashSet<BlockPosition>(this.blocks)) {
            Block block = position.getBlock();
            if (!BlockStorage.check((Block)block, (String)this.sfItem.getId())) {
                this.blocks.remove(position);
                continue;
            }
            this.runTask(block);
        }
        this.ticks += 10;
    }

    public abstract void runTask(Block var1);

    public void addBlock(Block block) {
        if (this.ticks == 0 && this.blocks.isEmpty()) {
            this.runTaskTimer((Plugin)WorldEditSlimefun.getInstance(), 20L, 10L);
        }
        this.blocks.add(new BlockPosition(block));
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

