/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.worldeditslimefun.utils;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.UnplaceableBlock;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.Material;

public class Utils {
    public static final List<String> SLIMEFUN_BLOCKS = new ArrayList<String>();
    public static final List<String> SLIMEFUN_ITEMS = new ArrayList<String>();
    public static final Map<String, Material> MATERIALS = new HashMap<String, Material>();

    public static void init() {
        for (SlimefunItem item : Slimefun.getRegistry().getEnabledSlimefunItems()) {
            if (!(item instanceof UnplaceableBlock) && item.getItem().getType().isBlock()) {
                SLIMEFUN_BLOCKS.add(item.getId());
            }
            SLIMEFUN_ITEMS.add(item.getId());
        }
        for (Material material : Material.values()) {
            if (material.isEmpty() || material.isLegacy()) continue;
            MATERIALS.put(material.name(), material);
        }
        SLIMEFUN_BLOCKS.sort(Comparator.naturalOrder());
        SLIMEFUN_ITEMS.sort(Comparator.naturalOrder());
    }

    @Nonnull
    public static String beautifyBlockPosition(@Nonnull BlockPosition position) {
        return "%s, %s, %s (%s)".formatted(position.getX(), position.getY(), position.getZ(), position.getWorld().getName());
    }
}

