/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.worldeditslimefun.commands;

import dev.j3fftw.worldeditslimefun.WorldEditSlimefun;
import dev.j3fftw.worldeditslimefun.acf.BaseCommand;
import dev.j3fftw.worldeditslimefun.acf.BukkitCommandCompletionContext;
import dev.j3fftw.worldeditslimefun.acf.BukkitCommandExecutionContext;
import dev.j3fftw.worldeditslimefun.acf.CommandCompletions;
import dev.j3fftw.worldeditslimefun.acf.CommandContexts;
import dev.j3fftw.worldeditslimefun.acf.PaperCommandManager;
import dev.j3fftw.worldeditslimefun.acf.annotation.CommandAlias;
import dev.j3fftw.worldeditslimefun.acf.annotation.CommandCompletion;
import dev.j3fftw.worldeditslimefun.acf.annotation.CommandPermission;
import dev.j3fftw.worldeditslimefun.acf.annotation.Default;
import dev.j3fftw.worldeditslimefun.acf.annotation.Subcommand;
import dev.j3fftw.worldeditslimefun.commands.flags.CommandFlag;
import dev.j3fftw.worldeditslimefun.commands.flags.CommandFlags;
import dev.j3fftw.worldeditslimefun.utils.PositionManager;
import dev.j3fftw.worldeditslimefun.utils.Utils;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.UnplaceableBlock;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

@CommandAlias(value="wesf|sfedit")
@CommandPermission(value="wesf.admin")
public class WorldEditSlimefunCommands
extends BaseCommand {
    public static void init(WorldEditSlimefun plugin) {
        PaperCommandManager manager = new PaperCommandManager((Plugin)plugin);
        CommandCompletions<BukkitCommandCompletionContext> completions = manager.getCommandCompletions();
        CommandContexts<BukkitCommandExecutionContext> contexts = manager.getCommandContexts();
        completions.registerStaticCompletion("slimefun_blocks", Utils.SLIMEFUN_BLOCKS);
        completions.registerAsyncCompletion("command_flags", context -> {
            ArrayList<String> args = new ArrayList<String>(Arrays.asList(context.getContextValueByName(String[].class, "commandFlags")));
            ArrayList<String> availableFlags = new ArrayList<String>(CommandFlags.FLAG_TYPES.keySet());
            availableFlags.removeAll(args);
            if (args.isEmpty()) {
                return availableFlags;
            }
            String currentArg = (String)args.remove(args.size() - 1);
            if (args.isEmpty()) {
                return availableFlags;
            }
            String lastArg = (String)args.get(args.size() - 1);
            if (CommandFlags.FLAG_TYPES.containsKey(lastArg)) {
                return CommandFlags.FLAG_TYPES.get(lastArg).getTabSuggestions((BukkitCommandCompletionContext)context);
            }
            if (args.size() % 2 == 0) {
                return availableFlags;
            }
            return List.of("invalid_flag");
        });
        manager.registerCommand(new WorldEditSlimefunCommands());
    }

    @Default
    public void onDefault(Player player) {
        player.sendMessage(ChatColor.RED + "Please provide a valid subcommand.");
    }

    @Subcommand(value="wand")
    public void onWand(Player player) {
        ItemStack wand = SlimefunItem.getOptionalById((String)"WESF_WAND").map(SlimefunItem::getItem).orElse(null);
        if (wand == null) {
            player.sendMessage(ChatColor.RED + "Wand not found!");
            return;
        }
        player.getInventory().addItem(new ItemStack[]{wand});
    }

    @Subcommand(value="pos1")
    public void onPos1(Player player) {
        PositionManager.addPositionOne(player);
    }

    @Subcommand(value="pos2")
    public void onPos2(Player player) {
        PositionManager.addPositionTwo(player);
    }

    @Subcommand(value="paste")
    @CommandCompletion(value="@slimefun_blocks @command_flags")
    public void paste(Player player, @Default(value="INVALID") String sfId, String[] commandFlags) {
        BlockPosition pos1 = PositionManager.getPositionOne(player);
        BlockPosition pos2 = PositionManager.getPositionTwo(player);
        if (pos1 == null || pos2 == null) {
            player.sendMessage(ChatColor.RED + "Select two positions first!");
            return;
        }
        SlimefunItem sfItem = SlimefunItem.getById((String)sfId);
        if (sfItem == null || sfItem instanceof UnplaceableBlock) {
            player.sendMessage(ChatColor.RED + "Invalid Slimefun item!");
            return;
        }
        List<CommandFlag<?>> flags = CommandFlags.getFlags(Arrays.asList(commandFlags));
        flags.removeIf(flag -> flag == null || !flag.canApply(sfItem));
        ItemStack item = sfItem.getItem();
        long start = System.currentTimeMillis();
        int amountOfBlocks = this.loopThroughSelection(pos1, pos2, block -> {
            if (BlockStorage.hasBlockInfo((Block)block)) {
                BlockStorage.deleteLocationInfoUnsafely((Location)block.getLocation(), (boolean)true);
            }
            block.setType(item.getType());
            BlockStorage.store((Block)block, (String)sfId);
            sfItem.callItemHandler(BlockPlaceHandler.class, handler -> {
                BlockPlaceEvent event = new BlockPlaceEvent(block, block.getState(), block.getRelative(BlockFace.DOWN), item, player, true, EquipmentSlot.HAND);
                handler.onPlayerPlace(event);
            });
            for (CommandFlag flag : flags) {
                flag.apply(flags, sfItem, (Block)block);
            }
        });
        long time = System.currentTimeMillis() - start;
        player.sendMessage("Pasted " + amountOfBlocks + " " + sfItem.getItemName() + ChatColor.WHITE + " (s)");
        player.sendMessage("Took " + time + "ms to paste!");
    }

    @Subcommand(value="clear")
    @CommandCompletion(value="true|false")
    public void clear(Player player, @Default(value="false") boolean callEvent) {
        BlockPosition pos1 = PositionManager.getPositionOne(player);
        BlockPosition pos2 = PositionManager.getPositionTwo(player);
        if (pos1 == null || pos2 == null) {
            return;
        }
        long start = System.currentTimeMillis();
        int amountOfBlocks = this.loopThroughSelection(pos1, pos2, block -> {
            if (callEvent && BlockStorage.hasBlockInfo((Block)block)) {
                SlimefunItem sfItem = BlockStorage.check((Block)block);
                sfItem.callItemHandler(BlockBreakHandler.class, handler -> {
                    BlockBreakEvent event = new BlockBreakEvent(block, player);
                    handler.onPlayerBreak(event, new ItemStack(Material.AIR), new ArrayList());
                });
            }
            block.setType(Material.AIR);
            BlockStorage.deleteLocationInfoUnsafely((Location)block.getLocation(), (boolean)true);
        });
        long time = System.currentTimeMillis() - start;
        player.sendMessage("Cleared " + amountOfBlocks + " blocks");
        player.sendMessage("Took " + time + "ms to clear!");
    }

    private int loopThroughSelection(BlockPosition pos1, BlockPosition pos2, Consumer<Block> blockRunnable) {
        int amountOfBlocks = 0;
        int upperX = Math.max(pos1.getX(), pos2.getX());
        int upperY = Math.max(pos1.getY(), pos2.getY());
        int upperZ = Math.max(pos1.getZ(), pos2.getZ());
        int lowerX = Math.min(pos1.getX(), pos2.getX());
        int lowerY = Math.min(pos1.getY(), pos2.getY());
        int lowerZ = Math.min(pos1.getZ(), pos2.getZ());
        for (int x = lowerX; x <= upperX; ++x) {
            for (int z = lowerZ; z <= upperZ; ++z) {
                for (int y = lowerY; y <= upperY; ++y) {
                    blockRunnable.accept(pos1.getWorld().getBlockAt(x, y, z));
                    ++amountOfBlocks;
                }
            }
        }
        return amountOfBlocks;
    }
}

