/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.worldeditslimefun.commands;

import dev.j3fftw.worldeditslimefun.WorldEditSlimefun;
import dev.j3fftw.worldeditslimefun.acf.BaseCommand;
import dev.j3fftw.worldeditslimefun.acf.annotation.CommandAlias;
import dev.j3fftw.worldeditslimefun.acf.annotation.CommandCompletion;
import dev.j3fftw.worldeditslimefun.acf.annotation.CommandPermission;
import dev.j3fftw.worldeditslimefun.acf.annotation.Default;
import dev.j3fftw.worldeditslimefun.acf.annotation.Subcommand;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.UnplaceableBlock;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;

@CommandAlias(value="wesf|sfedit")
public class WorldEditSlimefunCommands
extends BaseCommand {
    @Default
    public void onDefault(Player player) {
        player.sendMessage(ChatColor.RED + "Please provide a valid subcommand.");
    }

    @Subcommand(value="pos1")
    @CommandPermission(value="wesf.admin")
    public void onPos1(Player player) {
        WorldEditSlimefun.addPositionOne(player);
        player.sendMessage("Set position 1 to " + this.beautifyBlockPosition(player));
    }

    @Subcommand(value="pos2")
    @CommandPermission(value="wesf.admin")
    public void onPos2(Player player) {
        WorldEditSlimefun.addPositionTwo(player);
        player.sendMessage("Set position 2 to " + this.beautifyBlockPosition(player));
    }

    public String beautifyBlockPosition(Player player) {
        BlockPosition position = new BlockPosition(player.getLocation());
        return "%s, %s, %s (%s)".formatted(position.getX(), position.getY(), position.getZ(), position.getWorld().getName());
    }

    @Subcommand(value="paste")
    @CommandPermission(value="wesf.admin")
    @CommandCompletion(value="@slimefun_items")
    public void paste(Player player, String sfId) {
        BlockPosition pos1 = WorldEditSlimefun.getPositionOne(player);
        BlockPosition pos2 = WorldEditSlimefun.getPositionTwo(player);
        if (pos1 == null || pos2 == null) {
            return;
        }
        SlimefunItem sfItem = SlimefunItem.getById((String)sfId);
        if (sfItem == null || sfItem instanceof UnplaceableBlock) {
            return;
        }
        long start = System.currentTimeMillis();
        int ammountOfBlocks = 0;
        int upperX = Math.max(pos1.getX(), pos2.getX());
        int upperY = Math.max(pos1.getY(), pos2.getY());
        int upperZ = Math.max(pos1.getZ(), pos2.getZ());
        int lowerX = Math.min(pos1.getX(), pos2.getX());
        int lowerY = Math.min(pos1.getY(), pos2.getY());
        int lowerZ = Math.min(pos1.getZ(), pos2.getZ());
        for (int x = lowerX; x <= upperX; ++x) {
            for (int z = lowerZ; z <= upperZ; ++z) {
                for (int y = lowerY; y <= upperY; ++y) {
                    Location location = new Location(player.getWorld(), (double)x, (double)y, (double)z);
                    player.getWorld().setType(location, sfItem.getItem().getType());
                    BlockStorage.store((Block)location.getBlock(), (String)sfItem.getId());
                    for (ItemHandler handler : sfItem.getHandlers()) {
                        if (!(handler instanceof BlockPlaceHandler)) continue;
                        BlockPlaceHandler blockPlaceHandler = (BlockPlaceHandler)handler;
                        Block block = location.getBlock();
                        BlockPlaceEvent event = new BlockPlaceEvent(block, block.getState(), block.getRelative(BlockFace.DOWN), sfItem.getItem(), player, true);
                        blockPlaceHandler.onPlayerPlace(event);
                    }
                    ++ammountOfBlocks;
                }
            }
        }
        long time = System.currentTimeMillis() - start;
        player.sendMessage("Pasted " + ammountOfBlocks + " " + sfItem.getItemName() + ChatColor.WHITE + " (s)");
        player.sendMessage("Took " + time + "ms to paste!");
    }

    @Subcommand(value="clear")
    @CommandCompletion(value="@boolean")
    @CommandPermission(value="wesf.admin")
    public void clear(Player player, boolean callEvent) {
        BlockPosition pos1 = WorldEditSlimefun.getPositionOne(player);
        BlockPosition pos2 = WorldEditSlimefun.getPositionTwo(player);
        if (pos1 == null || pos2 == null) {
            return;
        }
        long start = System.currentTimeMillis();
        int ammountOfBlocks = 0;
        int upperX = Math.max(pos1.getX(), pos2.getX());
        int upperY = Math.max(pos1.getY(), pos2.getY());
        int upperZ = Math.max(pos1.getZ(), pos2.getZ());
        int lowerX = Math.min(pos1.getX(), pos2.getX());
        int lowerY = Math.min(pos1.getY(), pos2.getY());
        int lowerZ = Math.min(pos1.getZ(), pos2.getZ());
        for (int x = lowerX; x <= upperX; ++x) {
            for (int z = lowerZ; z <= upperZ; ++z) {
                for (int y = lowerY; y <= upperY; ++y) {
                    Location location = new Location(player.getWorld(), (double)x, (double)y, (double)z);
                    if (callEvent && BlockStorage.hasBlockInfo((Location)location)) {
                        SlimefunItem sfItem = SlimefunItem.getById((String)BlockStorage.check((Location)location).getId());
                        for (ItemHandler handler : sfItem.getHandlers()) {
                            if (!(handler instanceof BlockBreakHandler)) continue;
                            BlockBreakHandler blockBreakHandler = (BlockBreakHandler)handler;
                            Block block = location.getBlock();
                            BlockBreakEvent event = new BlockBreakEvent(block, player);
                            blockBreakHandler.onPlayerBreak(event, null, null);
                        }
                    }
                    player.getWorld().setType(location, Material.AIR);
                    BlockStorage.deleteLocationInfoUnsafely((Location)location, (boolean)true);
                    ++ammountOfBlocks;
                }
            }
        }
        long time = System.currentTimeMillis() - start;
        player.sendMessage("Cleared " + ammountOfBlocks + " blocks");
        player.sendMessage("Took " + time + "ms to clear!");
    }
}

