/*
 * Decompiled with CFR 0.152.
 */
package dev.j3fftw.worldeditslimefun;

import co.aikar.commands.PaperCommandManager;
import dev.j3fftw.worldeditslimefun.commands.WorldEditSlimefunCommands;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.UnplaceableBlock;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bstats.bukkit.Metrics;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class WorldEditSlimefun
extends JavaPlugin
implements SlimefunAddon {
    @Nonnull
    private static final Map<UUID, BlockPosition> STORED_POSITION_ONE = new HashMap<UUID, BlockPosition>();
    @Nonnull
    private static final Map<UUID, BlockPosition> STORED_POSITION_TWO = new HashMap<UUID, BlockPosition>();

    public void onEnable() {
        if (!new File(this.getDataFolder(), "config.yml").exists()) {
            this.saveDefaultConfig();
        }
        if (this.getConfig().getBoolean("auto-update", true) && this.getDescription().getVersion().startsWith("DEV - ")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), "WorldEditSlimefun", "Dev").start();
        }
        new Metrics(this, 20799);
        PaperCommandManager paperCommandManager = new PaperCommandManager((Plugin)this);
        paperCommandManager.registerCommand(new WorldEditSlimefunCommands());
        paperCommandManager.getCommandCompletions().registerCompletion("boolean", context -> List.of("true", "false"));
        paperCommandManager.getCommandCompletions().registerCompletion("slimefun_items", context -> {
            List slimefunItems = Slimefun.getRegistry().getEnabledSlimefunItems();
            ArrayList<String> placeableItems = new ArrayList<String>();
            for (SlimefunItem item : slimefunItems) {
                if (item instanceof UnplaceableBlock || !item.getItem().getType().isBlock()) continue;
                placeableItems.add(item.getId());
            }
            return placeableItems;
        });
    }

    public void onDisable() {
    }

    public static void addPositionOne(@Nonnull Player player) {
        STORED_POSITION_ONE.put(player.getUniqueId(), new BlockPosition(player.getLocation()));
    }

    public static void addPositionTwo(@Nonnull Player player) {
        STORED_POSITION_TWO.put(player.getUniqueId(), new BlockPosition(player.getLocation()));
    }

    @Nullable
    public static BlockPosition getPositionOne(@Nonnull Player player) {
        return STORED_POSITION_ONE.get(player.getUniqueId());
    }

    @Nullable
    public static BlockPosition getPositionTwo(@Nonnull Player player) {
        return STORED_POSITION_TWO.get(player.getUniqueId());
    }

    @NotNull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    @Nullable
    public String getBugTrackerURL() {
        return "https://github.com/Slimefun-Addon-Community/WorldEditSlimefun/issues";
    }
}

