/*
 * Decompiled with CFR 0.152.
 */
package me.schntgaispock.wildernether.loot;

import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import me.schntgaispock.wildernether.loot.LootTable;
import me.schntgaispock.wildernether.util.GeneralUtil;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class LootTableCollection {
    Map<Material, LootTable> lootTables;
    double[] defaultRates;
    private double defaultRatesTotal;
    Map<String, Pair<double[], Double>> toolRates = new HashMap<String, Pair<double[], Double>>();

    public LootTableCollection() {
        this.lootTables = new HashMap<Material, LootTable>();
    }

    public LootTableCollection setDefaultRates(double[] rates) {
        this.defaultRates = rates;
        this.defaultRatesTotal = GeneralUtil.sum(rates);
        return this;
    }

    private LootTableCollection addTool(String tool, double[] rates, double total) {
        this.toolRates.put(tool, (Pair<double[], Double>)new Pair((Object)rates, (Object)total));
        return this;
    }

    public LootTableCollection addTool(String tool, double[] rates) {
        double[] newRates = GeneralUtil.zipMult(this.defaultRates, rates);
        return this.addTool(tool, newRates, GeneralUtil.sum(newRates));
    }

    public LootTableCollection addTool(String tool) {
        return this.addTool(tool, this.defaultRates, this.defaultRatesTotal);
    }

    @ParametersAreNonnullByDefault
    public LootTableCollection put(Material blockType, ItemStack[][] loot) {
        this.lootTables.put(blockType, new LootTable(loot));
        return this;
    }

    public boolean hasTable(Material blockType) {
        return this.lootTables.containsKey(blockType);
    }

    @ParametersAreNonnullByDefault
    public ItemStack getDrop(Material blockType, String toolName) {
        LootTable table = this.lootTables.get(blockType);
        Pair<double[], Double> rates = this.toolRates.get(toolName);
        if (table == null) {
            return null;
        }
        if (rates == null) {
            return null;
        }
        return table.getDrop((double[])rates.getFirstValue(), (Double)rates.getSecondValue()).clone();
    }

    public Map<Material, LootTable> getLootTables() {
        return this.lootTables;
    }

    public double[] getDefaultRates() {
        return this.defaultRates;
    }

    public Map<String, Pair<double[], Double>> getToolRates() {
        return this.toolRates;
    }
}

