/*
 * Decompiled with CFR 0.152.
 */
package me.schntgaispock.infinitylib.commands;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import me.schntgaispock.infinitylib.commands.AliasesCommand;
import me.schntgaispock.infinitylib.commands.InfoCommand;
import me.schntgaispock.infinitylib.commands.ParentCommand;
import me.schntgaispock.infinitylib.common.Events;
import me.schntgaispock.infinitylib.core.AbstractAddon;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;

@ParametersAreNonnullByDefault
public final class AddonCommand
extends ParentCommand
implements TabExecutor,
Listener {
    private final String help;
    private final String slashHelp;

    public AddonCommand(String command) {
        this(Objects.requireNonNull(AbstractAddon.instance().getCommand(command), "No such command '" + command + "'! Add it it to your plugin.yml!"));
    }

    public AddonCommand(PluginCommand command) {
        super(command.getName(), command.getDescription());
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
        Events.registerListener(this);
        this.help = "help " + command.getName();
        this.slashHelp = "/" + this.help;
        this.addSub(new InfoCommand((SlimefunAddon)AbstractAddon.instance()));
        this.addSub(new AliasesCommand(command));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onServerCommand(ServerCommandEvent e) {
        if (e.getCommand().toLowerCase(Locale.ROOT).startsWith(this.help)) {
            e.setCommand(this.name());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onPlayerCommand(PlayerCommandPreprocessEvent e) {
        if (e.getMessage().toLowerCase(Locale.ROOT).startsWith(this.slashHelp)) {
            e.setMessage("/" + this.name());
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        this.execute(sender, args);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> strings = new ArrayList<String>();
        this.complete(sender, args, strings);
        ArrayList<String> returnList = new ArrayList<String>();
        String arg = args[args.length - 1].toLowerCase(Locale.ROOT);
        for (String item : strings) {
            if (item.toLowerCase(Locale.ROOT).contains(arg)) {
                returnList.add(item);
                if (returnList.size() < 64) continue;
                break;
            }
            if (!item.equalsIgnoreCase(arg)) continue;
            return Collections.emptyList();
        }
        return returnList;
    }

    @Override
    String fullName() {
        return this.name();
    }
}

