/*
 * Decompiled with CFR 0.152.
 */
package me.schntgaispock.wildernether.slimefun.items;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.schntgaispock.infinitylib.machines.MenuBlock;
import me.schntgaispock.wildernether.slimefun.WildernetherRecipes;
import me.schntgaispock.wildernether.util.GeneralUtil;
import me.schntgaispock.wildernether.util.Theme;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class BlackstoneStove
extends MenuBlock {
    public static final int[] GUI_BACKGROUND_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 15, 17, 18, 20, 24, 26, 27, 29, 33, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 52, 53};
    public static final int[] GUI_BOWL_SLOTS = new int[]{10, 28};
    public static final int[] GUI_RECIPE_SLOTS = new int[]{30, 31, 32};
    public static final int[] GUI_OUTPUT_SLOTS = new int[]{16, 34};
    public static final int[] GUI_COOK_SLOTS = new int[]{49};
    public static final int BOWL_SLOT = 19;
    public static final int[] RECIPE_SLOTS = new int[]{12, 13, 14, 21, 22, 23};
    public static final int COOK_SLOT = GUI_COOK_SLOTS[0];
    public static final int OUTPUT_SLOT = 25;
    public static final String COOK_CONFIRM_NAME = "Click to cook!";
    public static final ItemStack BOWL_BORDER_ITEM = new CustomItemStack(Material.BLUE_STAINED_GLASS_PANE, "&9Container", new String[0]);
    public static final ItemStack RECIPE_BORDER_ITEM = new CustomItemStack(Material.CAMPFIRE, Theme.CUISINE.getColor() + "Recipe", new String[0]);

    @ParametersAreNonnullByDefault
    public BlackstoneStove(ItemGroup ig, SlimefunItemStack is, RecipeType rt, ItemStack[] rc) {
        super(ig, is, rt, rc);
    }

    public static ItemStack getCraftConfirmItem(@Nonnull Mode mode) {
        return new CustomItemStack(Material.LIME_STAINED_GLASS_PANE, "&aClick to cook!", new String[]{"&7Mode: &f" + mode.toString()});
    }

    public static Mode getMode(Location l) {
        if (l.getBlockY() == 320) {
            return Mode.Oven;
        }
        Block blockOnTop = l.getWorld().getBlockAt(l.getBlockX(), l.getBlockY() + 1, l.getBlockZ());
        return switch (blockOnTop.getType()) {
            case Material.CAULDRON, Material.LAVA_CAULDRON, Material.WATER_CAULDRON, Material.POWDER_SNOW_CAULDRON -> Mode.Pot;
            case Material.HEAVY_WEIGHTED_PRESSURE_PLATE -> Mode.Frying;
            case Material.LIGHT_WEIGHTED_PRESSURE_PLATE -> Mode.Brewing;
            default -> Mode.Oven;
        };
    }

    public static Mode getMode(Block b) {
        return BlackstoneStove.getMode(b.getLocation());
    }

    @Override
    protected void setup(BlockMenuPreset preset) {
        preset.drawBackground(GUI_BACKGROUND_SLOTS);
        preset.drawBackground(BOWL_BORDER_ITEM, GUI_BOWL_SLOTS);
        preset.drawBackground(RECIPE_BORDER_ITEM, GUI_RECIPE_SLOTS);
        preset.drawBackground(OUTPUT_BORDER, GUI_OUTPUT_SLOTS);
        preset.drawBackground(BlackstoneStove.getCraftConfirmItem(Mode.Oven), GUI_COOK_SLOTS);
    }

    @Override
    protected int[] getInputSlots() {
        return new int[]{12, 13, 14, 21, 22, 23, 19};
    }

    @Override
    protected int[] getOutputSlots() {
        return new int[]{25};
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void onNewInstance(BlockMenu menu, Block b) {
        menu.addMenuOpeningHandler(player -> player.getOpenInventory().getTopInventory().setItem(49, BlackstoneStove.getCraftConfirmItem(BlackstoneStove.getMode(b))));
        menu.addMenuClickHandler(COOK_SLOT, (player, clickedSlot, clickedItem, action) -> {
            Inventory inv = player.getOpenInventory().getTopInventory();
            ItemStack[] currentRecipe = new ItemStack[9];
            for (int i = 0; i < 6; ++i) {
                int slot = RECIPE_SLOTS[i];
                currentRecipe[i] = inv.getItem(slot);
            }
            currentRecipe[7] = inv.getItem(19);
            ItemStack recipeOutput = (switch (BlackstoneStove.getMode(b)) {
                case Mode.Frying -> WildernetherRecipes.RecipeCollections.BLACKSTONE_STOVE_FRYING;
                case Mode.Pot -> WildernetherRecipes.RecipeCollections.BLACKSTONE_STOVE_POT;
                case Mode.Brewing -> WildernetherRecipes.RecipeCollections.BLACKSTONE_STOVE_BREWING;
                default -> WildernetherRecipes.RecipeCollections.BLACKSTONE_STOVE_OVEN;
            }).getOrNull(currentRecipe);
            if (recipeOutput == null) {
                player.sendMessage(Theme.CUISINE.getColor() + "Invalid " + BlackstoneStove.getMode(b).toString().toLowerCase() + " recipe!");
                return false;
            }
            int outputSlot = 25;
            ItemStack currentlyInOutput = inv.getItem(outputSlot);
            if (currentlyInOutput == null) {
                inv.setItem(outputSlot, recipeOutput.clone());
            } else if (recipeOutput.isSimilar(currentlyInOutput)) {
                if (currentlyInOutput.getMaxStackSize() == currentlyInOutput.getAmount()) {
                    player.sendMessage(Theme.CUISINE.getColor() + "Output is full!");
                    return false;
                }
                currentlyInOutput.setAmount(currentlyInOutput.getAmount() + 1);
            } else {
                player.sendMessage(Theme.CUISINE.getColor() + "Output is occupied!");
                return false;
            }
            for (int i = 0; i < 8; ++i) {
                ItemStack item = currentRecipe[i];
                if (item == null) continue;
                item.setAmount(item.getAmount() - 1);
                ItemStack returnItem = i != 7 ? GeneralUtil.returnItemAfterUsing(item) : null;
                HashMap leftOvers = new HashMap();
                if (returnItem == null || (leftOvers = player.getInventory().addItem(new ItemStack[]{returnItem})).isEmpty() || (leftOvers = inv.addItem(new ItemStack[]{(ItemStack)leftOvers.get(0)})).isEmpty()) continue;
                player.getWorld().dropItemNaturally(player.getLocation(), (ItemStack)leftOvers.get(0));
            }
            return false;
        });
        super.onNewInstance(menu, b);
    }

    public static enum Mode {
        Oven,
        Frying,
        Pot,
        Brewing;

    }
}

