/*
 * Decompiled with CFR 0.152.
 */
package me.schntgaispock.wildernether.loot;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.schntgaispock.wildernether.util.GeneralUtil;
import org.bukkit.inventory.ItemStack;

public class LootTable {
    final ItemStack[][] loot;

    @ParametersAreNonnullByDefault
    public LootTable(ItemStack[][] loot) {
        this.loot = loot;
    }

    @Nullable
    public ItemStack getDrop(@Nonnull double[] rates, @Nonnull double total) {
        if (rates.length != this.loot.length) {
            throw new IllegalArgumentException("`rates` must have a length of " + this.loot.length);
        }
        int index = GeneralUtil.pickRandomIndexFromWeightedArrayAndTotal(rates, total);
        return GeneralUtil.pickRandomElementFromUnweightedList(this.loot[index]);
    }

    public ItemStack[][] getLoot() {
        return this.loot;
    }
}

