/*
 * Decompiled with CFR 0.152.
 */
package me.schntgaispock.wildernether;

import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.schntgaispock.bstats.bukkit.Metrics;
import me.schntgaispock.infinitylib.core.AbstractAddon;
import me.schntgaispock.wildernether.integration.GastronomiconSetup;
import me.schntgaispock.wildernether.integration.SlimeHUDSetup;
import me.schntgaispock.wildernether.listeners.Listeners;
import me.schntgaispock.wildernether.managers.ItemManager;
import me.schntgaispock.wildernether.managers.LootManager;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;

public class Wildernether
extends AbstractAddon {
    static Wildernether instance;
    final Random random = ThreadLocalRandom.current();

    public Wildernether() {
        super("SchnTgaiSpock", "Wildernether", "master", "options.auto-update");
    }

    public static Wildernether getInstance() {
        return instance;
    }

    public Random getRandom() {
        return this.random;
    }

    @Override
    public void enable() {
        instance = this;
        this.getLogger().info("#=======================================#");
        this.getLogger().info("#    Wildernether - By SchnTgaiSpock    #");
        this.getLogger().info("#=======================================#");
        if (this.getConfig().getBoolean("options.auto-update")) {
            if (this.getDescription().getVersion().startsWith("Dev - ")) {
                new BlobBuildUpdater((Plugin)this, this.getFile(), "Wildernether", "Dev").start();
            } else {
                this.getLogger().info("This is an unofficial build of Wildernether, so auto updates are disabled!");
                this.getLogger().info("You can download the official build here: https://blob.build/project/Wildernether");
            }
        }
        ItemManager.setup();
        LootManager.setup();
        Listeners.setup();
        Metrics metrics = new Metrics(this, 15487);
        if (Wildernether.getInstance().getServer().getPluginManager().isPluginEnabled("SlimeHUD")) {
            try {
                this.getLogger().info("SlimeHUD was found on this server!");
                this.getLogger().info("Setting up Wildernether for SlimeHUD...");
                SlimeHUDSetup.setup();
            }
            catch (NoClassDefFoundError e) {
                this.getLogger().warning("This server is using an old version of SlimeHUD that is incompatitable with this version of Wildernether.");
                this.getLogger().warning("Please update SlimeHUD to version 1.2.0 or higher!");
            }
        }
        if (Wildernether.getInstance().getServer().getPluginManager().isPluginEnabled("Gastronomicon")) {
            try {
                this.getLogger().info("Gastronomicon was found on this server!");
                this.getLogger().info("Setting up Wildernether for Gastronomicon...");
                GastronomiconSetup.setup();
            }
            catch (NoClassDefFoundError e) {
                this.getLogger().warning("This server is using an old version of Gastronomicon that is incompatitable with this version of Wildernether.");
                this.getLogger().warning("Please update Gastronomicon to version 1.1.0 or higher!");
            }
        }
    }

    @Override
    protected void disable() {
        instance = null;
    }

    public static NamespacedKey newNamespacedKey(@Nonnull String name) {
        return new NamespacedKey((Plugin)Wildernether.getInstance(), name);
    }
}

