/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.utils;

import java.util.logging.Level;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.villagertrade.VillagerTrade;

public final class Debug {
    public static boolean isEnabled() {
        return VillagerTrade.getConfigManager().isDebug();
    }

    @ParametersAreNonnullByDefault
    public static void log(String message, Object ... args) {
        if (Debug.isEnabled()) {
            VillagerTrade.log(Level.INFO, "[DEBUG] " + message, args);
        }
    }

    @ParametersAreNonnullByDefault
    public static void logRaw(Object obj) {
        if (Debug.isEnabled()) {
            VillagerTrade.getInstance().getLogger().log(Level.INFO, "[DEBUG] {0}", obj);
        }
    }

    private Debug() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

