/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.implementation.listeners;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.guizhanss.villagertrade.VillagerTrade;
import net.guizhanss.villagertrade.api.trades.TradeConfiguration;
import net.guizhanss.villagertrade.utils.Debug;
import org.bukkit.entity.Entity;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.inventory.MerchantRecipe;

public final class WanderingTraderListener
implements Listener {
    @EventHandler
    public void onSpawn(@Nonnull EntitySpawnEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof WanderingTrader)) {
            return;
        }
        WanderingTrader trader = (WanderingTrader)entity;
        ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>(trader.getRecipes());
        for (TradeConfiguration tradeConfig : VillagerTrade.getRegistry().getWanderingTraderConfigurations()) {
            if (!tradeConfig.getTraderTypes().isValid((Entity)trader)) continue;
            recipes.add(tradeConfig.getMerchantRecipe());
            Debug.log("Added MerchantRecipe to WanderingTrader: " + tradeConfig.getKey(), new Object[0]);
        }
        trader.setRecipes(recipes);
    }
}

