/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.api.trades.mutables;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.guizhanss.villagertrade.VillagerTrade;
import net.guizhanss.villagertrade.api.trades.TradeItem;
import net.guizhanss.villagertrade.utils.ItemUtils;
import org.bukkit.inventory.ItemStack;

public final class MutableTradeItem {
    private ItemStack item;
    private TradeItem.TradeItemType type;
    private String id;
    private int amount;

    public MutableTradeItem() {
        this.item = null;
        this.type = TradeItem.TradeItemType.NONE;
        this.id = null;
        this.amount = 1;
    }

    public MutableTradeItem(@Nonnull TradeItem tradeItem) {
        Preconditions.checkArgument((tradeItem != null ? 1 : 0) != 0, (Object)"tradeItem cannot be null");
        this.item = tradeItem.getItem();
        this.type = tradeItem.getType();
        this.id = tradeItem.getId();
        this.amount = tradeItem.getAmount();
    }

    public void setItem(@Nullable ItemStack item) {
        this.item = item;
        if (item == null || item.getType().isAir()) {
            this.type = TradeItem.TradeItemType.NONE;
            this.id = null;
            this.amount = 1;
            return;
        }
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)item);
        if (sfItem != null) {
            this.type = TradeItem.TradeItemType.SLIMEFUN;
            this.id = sfItem.getId();
        } else if (item.hasItemMeta()) {
            this.type = TradeItem.TradeItemType.CUSTOM;
            this.id = VillagerTrade.getCustomItemService().getId(item);
            if (this.id == null) {
                this.id = VillagerTrade.getCustomItemService().addItem(item);
            }
        } else {
            this.type = TradeItem.TradeItemType.VANILLA;
            this.id = item.getType().name();
        }
        this.amount = item.getAmount();
    }

    public boolean isItem(@Nullable ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return this.type == TradeItem.TradeItemType.NONE;
        }
        if (item.getAmount() != this.amount) {
            return false;
        }
        return switch (this.type) {
            case TradeItem.TradeItemType.VANILLA -> {
                if (this.item.getType() == item.getType()) {
                    yield true;
                }
                yield false;
            }
            case TradeItem.TradeItemType.SLIMEFUN -> SlimefunItem.getById((String)this.id).isItem(item);
            case TradeItem.TradeItemType.CUSTOM -> ItemUtils.canStack(this.item, item);
            default -> false;
        };
    }

    public boolean setAmount(int amount) {
        boolean isValid = true;
        if (amount < 1) {
            amount = 1;
            isValid = false;
        }
        if (amount > this.item.getMaxStackSize()) {
            amount = this.item.getMaxStackSize();
            isValid = false;
        }
        this.amount = amount;
        this.item.setAmount(amount);
        return isValid;
    }

    public int getMaxStackSize() {
        if (this.item != null && !this.item.getType().isAir()) {
            return this.item.getMaxStackSize();
        }
        return 1;
    }

    public TradeItem toTradeItem() {
        return new TradeItem(this.type.toString(), this.id, this.amount);
    }

    @Nonnull
    public String toString() {
        return "MutableTradeItem(type=" + this.type + ", id=" + this.id + ", amount=" + this.amount + ")";
    }

    @Nonnull
    public String toShortString(boolean displayAmount) {
        StringBuilder builder = new StringBuilder(this.type.toString());
        if (this.type != TradeItem.TradeItemType.NONE) {
            builder.append(':').append(this.id);
            if (displayAmount && this.amount != 1) {
                builder.append(':').append(this.amount);
            }
        }
        return builder.toString();
    }

    public ItemStack getItem() {
        return this.item;
    }

    public TradeItem.TradeItemType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public int getAmount() {
        return this.amount;
    }
}

