/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.api.trades;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.guizhanss.villagertrade.VillagerTrade;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;

public final class TraderTypes {
    private static final String WANDERING_TRADER = "WANDERING_TRADER";
    private final boolean hasWanderingTrader;
    private final List<Villager.Profession> villagerProfessions;

    public TraderTypes(boolean hasWanderingTrader, @Nullable List<Villager.Profession> villagerProfessions) {
        this.hasWanderingTrader = hasWanderingTrader;
        this.villagerProfessions = Objects.requireNonNullElseGet(villagerProfessions, ArrayList::new);
    }

    @Nonnull
    public static TraderTypes loadFromConfig(@Nonnull List<String> traderList) {
        Preconditions.checkArgument((traderList != null ? 1 : 0) != 0, (Object)"The trader list cannot be null");
        boolean hasWanderingTrader = false;
        ArrayList<Villager.Profession> professions = new ArrayList<Villager.Profession>();
        for (String trader : traderList) {
            if (trader.equalsIgnoreCase(WANDERING_TRADER)) {
                hasWanderingTrader = true;
                continue;
            }
            try {
                Villager.Profession profession = Villager.Profession.valueOf((String)trader.toUpperCase());
                professions.add(profession);
            }
            catch (IllegalArgumentException ex) {
                VillagerTrade.log(Level.WARNING, "Invalid trader type: " + trader + ", must be WANDERING_TRADER or any villager profession", new Object[0]);
            }
        }
        return new TraderTypes(hasWanderingTrader, professions);
    }

    public List<String> toStringList() {
        ArrayList<String> traderTypes = new ArrayList<String>();
        if (this.hasWanderingTrader) {
            traderTypes.add(WANDERING_TRADER);
        }
        for (Villager.Profession profession : this.villagerProfessions) {
            traderTypes.add(profession.toString());
        }
        return traderTypes;
    }

    @Nonnull
    public String toHumanizedString() {
        return this.toStringList().stream().map(ChatUtils::humanize).collect(Collectors.joining(", "));
    }

    @Nonnull
    public String toString() {
        return "TraderTypes(wanderingTrader = " + this.hasWanderingTrader + ", villagerProfessions = " + this.villagerProfessions.stream().map(Enum::toString).collect(Collectors.joining(", ")) + ")";
    }

    public boolean isEmpty() {
        return !this.hasWanderingTrader && !this.hasVillager();
    }

    public boolean hasVillager() {
        return !this.villagerProfessions.isEmpty();
    }

    public boolean isValid(@Nonnull Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"The entity cannot be null");
        if (this.hasWanderingTrader && entity instanceof WanderingTrader) {
            return true;
        }
        Entity entity2 = entity;
        if (entity2 instanceof Villager) {
            Villager villager = (Villager)entity2;
            return this.hasProfession(villager.getProfession());
        }
        return false;
    }

    public boolean hasProfession(@Nonnull Villager.Profession profession) {
        Preconditions.checkArgument((profession != null ? 1 : 0) != 0, (Object)"The profession cannot be null");
        return this.villagerProfessions.contains(profession);
    }

    public boolean hasWanderingTrader() {
        return this.hasWanderingTrader;
    }

    public List<Villager.Profession> getVillagerProfessions() {
        return this.villagerProfessions;
    }
}

