/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.implementation.menu;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import net.guizhanss.villagertrade.VillagerTrade;
import net.guizhanss.villagertrade.api.trades.TraderTypes;
import net.guizhanss.villagertrade.utils.Heads;
import net.guizhanss.villagertrade.utils.SoundUtils;
import net.guizhanss.villagertrade.utils.constants.Strings;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;

public final class TraderTypesMenu {
    private static final int[] BACKGROUND = new int[]{18, 19, 21, 22, 23, 25, 26};
    private static final int CONFIRM_SLOT = 20;
    private static final int CANCEL_SLOT = 24;
    private final ChestMenu menu;
    private final Player player;
    private Consumer<TraderTypes> confirmCallback;
    private Runnable cancelCallback;
    private boolean wanderingTrader;
    private List<Villager.Profession> villagerProfessions;

    @ParametersAreNonnullByDefault
    private TraderTypesMenu(Player player, TraderTypes types, Consumer<TraderTypes> confirmCallback, Runnable cancelCallback) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        Preconditions.checkArgument((types != null ? 1 : 0) != 0, (Object)"TraderTypes cannot be null");
        Preconditions.checkArgument((confirmCallback != null ? 1 : 0) != 0, (Object)"Confirm callback cannot be null");
        Preconditions.checkArgument((cancelCallback != null ? 1 : 0) != 0, (Object)"Cancel callback cannot be null");
        this.player = player;
        this.confirmCallback = confirmCallback;
        this.cancelCallback = cancelCallback;
        this.wanderingTrader = types.hasWanderingTrader();
        this.villagerProfessions = types.getVillagerProfessions();
        this.menu = new ChestMenu(VillagerTrade.getLocalization().getString("menu.trader_types.title"));
        this.setupMenu();
        this.openMenu();
    }

    @ParametersAreNonnullByDefault
    public static TraderTypesMenu open(Player p, TraderTypes types, Consumer<TraderTypes> confirmCallback, Runnable cancelCallback) {
        return new TraderTypesMenu(p, types, confirmCallback, cancelCallback);
    }

    @ParametersAreNonnullByDefault
    private void setupMenu() {
        for (int slot2 : BACKGROUND) {
            this.menu.addItem(slot2, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        this.menu.setEmptySlotsClickable(false);
        this.menu.setPlayerInventoryClickable(false);
        this.menu.addMenuOpeningHandler(SoundUtils::playOpenMenuSound);
        this.menu.addMenuCloseHandler(player -> this.cancelCallback.run());
        this.menu.addItem(0, this.getTraderItem(Heads.WANDERING_TRADER, "wandering_trader", this.wanderingTrader), (player1, slot, item, clickAction) -> {
            this.wanderingTrader = !this.wanderingTrader;
            this.menu.replaceExistingItem(slot, this.getTraderItem(Heads.WANDERING_TRADER, "wandering_trader", this.wanderingTrader));
            return false;
        });
        int slot3 = 1;
        for (Villager.Profession profession : Villager.Profession.values()) {
            if (profession == Villager.Profession.NONE || profession == Villager.Profession.NITWIT) continue;
            this.menu.addItem(slot3++, this.getTraderItem(Heads.valueOf(profession.name()), profession.name(), this.villagerProfessions.contains(profession)), (player, slot1, item, action) -> {
                if (this.villagerProfessions.contains(profession)) {
                    this.villagerProfessions.remove(profession);
                } else {
                    this.villagerProfessions.add(profession);
                }
                this.menu.replaceExistingItem(slot1, this.getTraderItem(Heads.valueOf(profession.name()), profession.name(), this.villagerProfessions.contains(profession)));
                return false;
            });
        }
        this.menu.addItem(20, this.getConfirmItem(), (player, slot1, item, action) -> {
            this.confirmCallback.accept(new TraderTypes(this.wanderingTrader, this.villagerProfessions));
            return false;
        });
        this.menu.addItem(24, this.getCancelItem(), (player, slot1, item, action) -> {
            this.cancelCallback.run();
            return false;
        });
    }

    private void openMenu() {
        this.menu.open(new Player[]{this.player});
    }

    @Nonnull
    private ItemStack getTraderItem(Heads hash, String name, boolean enabled) {
        return new CustomItemStack(hash.getItem(), ChatColor.YELLOW + ChatUtils.humanize((String)name) + ChatColor.GRAY + ": " + (enabled ? Strings.CHECK : Strings.CROSS), new String[0]);
    }

    @Nonnull
    private ItemStack getConfirmItem() {
        return new CustomItemStack(Material.GREEN_STAINED_GLASS_PANE, VillagerTrade.getLocalization().getString("menu.trader_types.confirm.name"), VillagerTrade.getLocalization().getStringList("menu.trader_types.confirm.lore"));
    }

    @Nonnull
    private ItemStack getCancelItem() {
        return new CustomItemStack(Material.RED_STAINED_GLASS_PANE, VillagerTrade.getLocalization().getString("menu.trader_types.cancel.name"), VillagerTrade.getLocalization().getStringList("menu.trader_types.cancel.lore"));
    }

    private void setConfirmCallback(Consumer<TraderTypes> confirmCallback) {
        this.confirmCallback = confirmCallback;
    }

    private void setCancelCallback(Runnable cancelCallback) {
        this.cancelCallback = cancelCallback;
    }

    private void setWanderingTrader(boolean wanderingTrader) {
        this.wanderingTrader = wanderingTrader;
    }

    private void setVillagerProfessions(List<Villager.Profession> villagerProfessions) {
        this.villagerProfessions = villagerProfessions;
    }
}

