/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.implementation.menu;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import net.guizhanss.villagertrade.VillagerTrade;
import net.guizhanss.villagertrade.api.trades.TradeConfiguration;
import net.guizhanss.villagertrade.api.trades.TradeItem;
import net.guizhanss.villagertrade.api.trades.TraderTypes;
import net.guizhanss.villagertrade.api.trades.mutables.MutableTradeItem;
import net.guizhanss.villagertrade.core.commands.subcommands.RemoveCommand;
import net.guizhanss.villagertrade.implementation.menu.TradeListMenu;
import net.guizhanss.villagertrade.implementation.menu.TradeMenuTask;
import net.guizhanss.villagertrade.implementation.menu.TraderTypesMenu;
import net.guizhanss.villagertrade.utils.ItemUtils;
import net.guizhanss.villagertrade.utils.MenuUtils;
import net.guizhanss.villagertrade.utils.SoundUtils;
import net.guizhanss.villagertrade.utils.Validators;
import net.guizhanss.villagertrade.utils.constants.Strings;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class TradeMenu {
    private static final int[] BACKGROUND = new int[]{0, 2, 3, 4, 5, 6, 8, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 34, 35, 36, 37, 38, 39, 41, 42, 43};
    private static final int BACK_SLOT = 1;
    private static final int INFO_SLOT = 7;
    private static final int SAVE_SLOT = 40;
    private static final int REMOVE_SLOT = 44;
    private static final int INPUT_1_INFO_SLOT = 9;
    private static final int INPUT_1_ITEM_SLOT = 10;
    private static final int INPUT_1_AMOUNT_SLOT = 11;
    private static final int INPUT_2_INFO_SLOT = 12;
    private static final int INPUT_2_ITEM_SLOT = 13;
    private static final int INPUT_2_AMOUNT_SLOT = 14;
    private static final int OUTPUT_INFO_SLOT = 15;
    private static final int OUTPUT_ITEM_SLOT = 16;
    private static final int OUTPUT_AMOUNT_SLOT = 17;
    private static final int TRADER_TYPES_SLOT = 29;
    private static final int MAX_USES_SLOT = 30;
    private static final int EXP_REWARD_SLOT = 31;
    private static final int EXP_VILLAGER_SLOT = 32;
    private static final int PRICE_MULTIPLIER_SLOT = 33;
    private static final String LANG_MENU = "menu.trade.";
    private static final String VALUE = "%value%";
    private final ChestMenu menu;
    private final Player player;
    private final Map<Integer, Consumer<Integer>> tickingHandlers = new HashMap<Integer, Consumer<Integer>>();
    private TradeConfiguration originalConfig;
    private String key;
    private TraderTypes traderTypes;
    private MutableTradeItem input1;
    private MutableTradeItem input2;
    private MutableTradeItem output;
    private int maxUses;
    private boolean expReward;
    private int expVillager;
    private float priceMultiplier;

    @ParametersAreNonnullByDefault
    public TradeMenu(Player player, String key) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        this.player = player;
        this.key = key;
        this.traderTypes = new TraderTypes(true, null);
        this.input1 = new MutableTradeItem();
        this.input2 = new MutableTradeItem();
        this.output = new MutableTradeItem();
        this.maxUses = 1;
        this.expReward = true;
        this.expVillager = 0;
        this.priceMultiplier = 0.0f;
        this.menu = new ChestMenu(VillagerTrade.getLocalization().getString("menu.trade.title"));
        this.setupMenu();
        this.openMenu();
    }

    @ParametersAreNonnullByDefault
    public TradeMenu(Player player, TradeConfiguration trade) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        Preconditions.checkArgument((trade != null ? 1 : 0) != 0, (Object)"TradeConfiguration cannot be null");
        this.player = player;
        this.originalConfig = trade;
        this.key = trade.getKey();
        this.traderTypes = trade.getTraderTypes();
        this.input1 = new MutableTradeItem(trade.getInput1());
        this.input2 = new MutableTradeItem(trade.getInput2());
        this.output = new MutableTradeItem(trade.getOutput());
        this.maxUses = trade.getMaxUses();
        this.expReward = trade.isExpReward();
        this.expVillager = trade.getExpVillager();
        this.priceMultiplier = trade.getPriceMultiplier();
        this.menu = new ChestMenu(VillagerTrade.getLocalization().getString("menu.trade.title"));
        this.setupMenu();
        this.openMenu();
    }

    @ParametersAreNonnullByDefault
    private void setupMenu() {
        for (int slot2 : BACKGROUND) {
            this.menu.addItem(slot2, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        this.menu.setEmptySlotsClickable(true);
        this.menu.setPlayerInventoryClickable(true);
        this.menu.addMenuOpeningHandler(player -> {
            TradeMenuTask.addPlayer(player.getUniqueId(), this);
            SoundUtils.playOpenMenuSound(player);
        });
        this.menu.addMenuCloseHandler(player -> TradeMenuTask.removePlayer(player.getUniqueId()));
        this.menu.addItem(1, this.getBackButton(this.player), (player, slot, item, action) -> {
            new TradeListMenu(player);
            return false;
        });
        this.menu.addItem(7, this.getInfoButton(), ChestMenuUtils.getEmptyClickHandler());
        this.addTradeItemSlots(9, 10, 11, Material.CYAN_STAINED_GLASS_PANE, "input.1", this.input1);
        this.addTradeItemSlots(12, 13, 14, Material.CYAN_STAINED_GLASS_PANE, "input.2", this.input2);
        this.addTradeItemSlots(15, 16, 17, Material.ORANGE_STAINED_GLASS_PANE, "output", this.output);
        this.menu.addItem(29, this.getTraderTypesButton(), (player, slot, item, action) -> {
            TraderTypesMenu.open(player, this.traderTypes, newTraderTypes -> {
                this.traderTypes = newTraderTypes;
                this.menu.replaceExistingItem(29, this.getTraderTypesButton());
                this.openMenu();
            }, this::openMenu);
            return false;
        });
        this.menu.addItem(30, this.getNumberSettingButton("max-uses", String.valueOf(this.maxUses)), (player, slot, item, action) -> {
            this.inputNumber("max-uses", String.valueOf(this.maxUses), Validators::isPositiveInteger, input -> {
                this.openMenu();
                if (input.isPresent()) {
                    this.maxUses = Integer.parseInt((String)input.get());
                    this.menu.replaceExistingItem(30, this.getNumberSettingButton("max-uses", (String)input.get()));
                }
            });
            return false;
        });
        this.menu.addItem(31, this.getBooleanSettingButton("exp-reward", this.expReward), (player, slot, item, action) -> {
            this.expReward = !this.expReward;
            this.menu.replaceExistingItem(31, this.getBooleanSettingButton("exp-reward", this.expReward));
            return false;
        });
        this.menu.addItem(32, this.getNumberSettingButton("exp-villager", String.valueOf(this.expVillager)), (player, slot, item, action) -> {
            this.inputNumber("exp-villager", String.valueOf(this.expVillager), Validators::isInteger, input -> {
                this.openMenu();
                if (input.isPresent()) {
                    this.expVillager = Integer.parseInt((String)input.get());
                    this.menu.replaceExistingItem(32, this.getNumberSettingButton("exp-villager", (String)input.get()));
                }
            });
            return false;
        });
        this.menu.addItem(33, this.getNumberSettingButton("price-multiplier", String.valueOf(this.priceMultiplier)), (player, slot, item, action) -> {
            this.inputNumber("price-multiplier", String.valueOf(this.priceMultiplier), Validators::isDouble, input -> {
                this.openMenu();
                if (input.isPresent()) {
                    this.priceMultiplier = Float.parseFloat((String)input.get());
                    this.menu.replaceExistingItem(33, this.getNumberSettingButton("price-multiplier", (String)input.get()));
                }
            });
            return false;
        });
        this.menu.addItem(40, this.getSaveButton(null), (player, slot, item, action) -> {
            if (this.getInvalidReason() != null) {
                return false;
            }
            TradeConfiguration newConfig = TradeConfiguration.builder().key(this.key).input1(this.input1.toTradeItem()).input2(this.input2.toTradeItem()).output(this.output.toTradeItem()).traderTypes(this.traderTypes).maxUses(this.maxUses).expReward(this.expReward).expVillager(this.expVillager).priceMultiplier(this.priceMultiplier).build();
            if (this.originalConfig != null) {
                VillagerTrade.getRegistry().clear(this.originalConfig);
            }
            newConfig.register((SlimefunAddon)VillagerTrade.getInstance());
            VillagerTrade.getConfigManager().saveTrade(newConfig);
            if (this.originalConfig == null) {
                this.menu.replaceExistingItem(44, this.getRemoveButton());
                this.menu.addMenuClickHandler(44, this::removeHandler);
            }
            return false;
        });
        this.tickingHandlers.put(40, slot -> this.menu.replaceExistingItem(40, this.getSaveButton(this.getInvalidReason())));
        if (this.originalConfig != null) {
            this.menu.addItem(44, this.getRemoveButton(), this::removeHandler);
        } else {
            this.menu.addItem(44, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
    }

    void tick() {
        for (Map.Entry<Integer, Consumer<Integer>> entry : this.tickingHandlers.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().accept(entry.getKey());
        }
    }

    private void openMenu() {
        this.menu.open(new Player[]{this.player});
    }

    private void addTradeItemSlots(int infoSlot, int itemSlot, int amountSlot, Material infoMaterial, String key, MutableTradeItem tradeItem) {
        this.menu.addItem(infoSlot, this.getItemInfoButton(infoMaterial, key, tradeItem), ChestMenuUtils.getEmptyClickHandler());
        this.menu.addItem(itemSlot, tradeItem.getItem());
        this.tickingHandlers.put(itemSlot, slot -> {
            ItemStack item = this.menu.getItemInSlot(slot.intValue());
            if (tradeItem.isItem(item)) {
                return;
            }
            tradeItem.setItem(item);
            this.refreshTradeItemSlots(infoSlot, itemSlot, amountSlot, infoMaterial, key, tradeItem);
        });
        this.menu.addItem(amountSlot, this.getItemAmountButton(tradeItem), (player, slot, item, action) -> {
            if (tradeItem.getType() == TradeItem.TradeItemType.NONE) {
                return false;
            }
            if (action.isShiftClicked()) {
                this.inputAmount(tradeItem, amount -> {
                    this.openMenu();
                    if (amount.isPresent()) {
                        tradeItem.setAmount((Integer)amount.get());
                        this.refreshTradeItemSlots(infoSlot, itemSlot, amountSlot, infoMaterial, key, tradeItem);
                    }
                });
            } else {
                if (action.isRightClicked()) {
                    tradeItem.setAmount(tradeItem.getAmount() - 1);
                } else {
                    tradeItem.setAmount(tradeItem.getAmount() + 1);
                }
                this.refreshTradeItemSlots(infoSlot, itemSlot, amountSlot, infoMaterial, key, tradeItem);
            }
            return false;
        });
    }

    private void refreshTradeItemSlots(int infoSlot, int itemSlot, int amountSlot, Material infoMaterial, String key, MutableTradeItem tradeItem) {
        this.menu.replaceExistingItem(infoSlot, this.getItemInfoButton(infoMaterial, key, tradeItem));
        this.menu.replaceExistingItem(itemSlot, tradeItem.getItem());
        this.menu.replaceExistingItem(amountSlot, this.getItemAmountButton(tradeItem));
    }

    @ParametersAreNonnullByDefault
    private void inputAmount(MutableTradeItem tradeItem, Consumer<Optional<Integer>> callback) {
        this.player.closeInventory();
        VillagerTrade.getLocalization().sendKeyedMessage((CommandSender)this.player, "menu.trade.amount.input", msg -> msg.replace("%itemInfo%", tradeItem.toShortString(false)).replace("%itemAmount%", String.valueOf(tradeItem.getAmount())));
        MenuUtils.awaitInput(this.player, playerInput -> {
            if (playerInput.equalsIgnoreCase("cancel")) {
                callback.accept(Optional.empty());
                return;
            }
            try {
                int amount = Integer.parseInt(playerInput);
                callback.accept(Optional.of(amount));
            }
            catch (NumberFormatException e) {
                VillagerTrade.getLocalization().sendKeyedMessage((CommandSender)this.player, "not-number");
                this.inputAmount(tradeItem, callback);
            }
        });
    }

    @ParametersAreNonnullByDefault
    private void inputNumber(String key, String value, Predicate<String> validator, Consumer<Optional<String>> callback) {
        this.player.closeInventory();
        VillagerTrade.getLocalization().sendKeyedMessage((CommandSender)this.player, LANG_MENU + key + ".input", msg -> msg.replace(VALUE, value));
        MenuUtils.awaitInput(this.player, playerInput -> {
            if (playerInput.equalsIgnoreCase("cancel")) {
                callback.accept(Optional.empty());
                return;
            }
            if (validator.test((String)playerInput)) {
                callback.accept(Optional.of(playerInput));
            } else {
                VillagerTrade.getLocalization().sendKeyedMessage((CommandSender)this.player, "not-number");
                this.inputNumber(key, value, validator, callback);
            }
        });
    }

    @Nullable
    private String getInvalidReason() {
        String langKey = "menu.trade.invalid-reason.";
        if (this.input1.getType() == TradeItem.TradeItemType.NONE) {
            return VillagerTrade.getLocalization().getString(langKey + "input.1");
        }
        if (this.output.getType() == TradeItem.TradeItemType.NONE) {
            return VillagerTrade.getLocalization().getString(langKey + "output");
        }
        if (this.traderTypes.isEmpty()) {
            return VillagerTrade.getLocalization().getString(langKey + "traders");
        }
        if (this.maxUses <= 0) {
            return VillagerTrade.getLocalization().getString(langKey + "max-uses");
        }
        if (this.expVillager < 0) {
            return VillagerTrade.getLocalization().getString(langKey + "exp-villager");
        }
        if (this.priceMultiplier < 0.0f) {
            return VillagerTrade.getLocalization().getString(langKey + "price-multiplier");
        }
        return null;
    }

    @Nonnull
    private ItemStack getBackButton(@Nonnull Player p) {
        return ChestMenuUtils.getBackButton((Player)p, (String[])VillagerTrade.getLocalization().getStringList("menu.trade.back.lore").toArray(new String[0]));
    }

    @Nonnull
    private ItemStack getInfoButton() {
        return MenuUtils.parseVariables(this.getItem(Material.BOOK, "info"), Map.of("%tradeKey%", this.key));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private ItemStack getItemInfoButton(Material material, String key, MutableTradeItem item) {
        return MenuUtils.parseVariables(this.getItem(material, key), Map.of("%itemType%", item.getType().toString(), "%itemId%", item.getId() != null ? item.getId() : "N/A", "%itemAmount%", String.valueOf(item.getAmount())));
    }

    @Nonnull
    private ItemStack getItemAmountButton(@Nonnull MutableTradeItem item) {
        return MenuUtils.parseVariables(this.getItem(Material.NAME_TAG, "amount"), Map.of("%amount%", String.valueOf(item.getAmount())));
    }

    @Nonnull
    private ItemStack getTraderTypesButton() {
        return MenuUtils.parseVariables(this.getItem(Material.NAME_TAG, "traders"), Map.of("%wanderingTrader%", this.traderTypes.hasWanderingTrader() ? Strings.CHECK : Strings.CROSS, "%villagers%", this.traderTypes.getVillagerProfessions().stream().map(profession -> ChatUtils.humanize((String)profession.toString())).collect(Collectors.joining(", "))));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private ItemStack getNumberSettingButton(String key, String current) {
        return MenuUtils.parseVariables(this.getItem(Material.BOOK, key), Map.of(VALUE, current));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private ItemStack getBooleanSettingButton(String key, boolean current) {
        return MenuUtils.parseVariables(this.getItem(Material.BOOK, key), Map.of(VALUE, current ? Strings.CHECK : Strings.CROSS));
    }

    @Nonnull
    private ItemStack getSaveButton(@Nullable String invalidReason) {
        if (invalidReason == null) {
            return this.getItem(Material.EMERALD, "save");
        }
        return ItemUtils.addLore(this.getItem(Material.BARRIER, "save-invalid"), List.of(invalidReason));
    }

    @Nonnull
    private ItemStack getRemoveButton() {
        return MenuUtils.parseVariables(this.getItem(Material.LAVA_BUCKET, "remove"), Map.of("%tradeKey%", this.key));
    }

    @ParametersAreNonnullByDefault
    private boolean removeHandler(Player player, int slot, ItemStack item, ClickAction action) {
        player.closeInventory();
        RemoveCommand.awaitRemoval(player, this.originalConfig, () -> new TradeListMenu(player));
        return false;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private ItemStack getItem(Material material, String key) {
        return new CustomItemStack(material, VillagerTrade.getLocalization().getString(LANG_MENU + key + ".name"), VillagerTrade.getLocalization().getStringList(LANG_MENU + key + ".lore"));
    }

    private void setOriginalConfig(TradeConfiguration originalConfig) {
        this.originalConfig = originalConfig;
    }

    private void setKey(String key) {
        this.key = key;
    }

    private void setTraderTypes(TraderTypes traderTypes) {
        this.traderTypes = traderTypes;
    }

    private void setInput1(MutableTradeItem input1) {
        this.input1 = input1;
    }

    private void setInput2(MutableTradeItem input2) {
        this.input2 = input2;
    }

    private void setOutput(MutableTradeItem output) {
        this.output = output;
    }

    private void setMaxUses(int maxUses) {
        this.maxUses = maxUses;
    }

    private void setExpReward(boolean expReward) {
        this.expReward = expReward;
    }

    private void setExpVillager(int expVillager) {
        this.expVillager = expVillager;
    }

    private void setPriceMultiplier(float priceMultiplier) {
        this.priceMultiplier = priceMultiplier;
    }
}

