/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.guizhanlib.minecraft.utils;

import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class ChatUtil {
    @Nonnull
    public static String color(@Nonnull String str) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)str);
    }

    @Nonnull
    public static List<String> color(@Nonnull List<String> strList) {
        Preconditions.checkArgument((strList != null ? 1 : 0) != 0, (Object)"String list cannot be null");
        return strList.stream().map(ChatUtil::color).collect(Collectors.toList());
    }

    @ParametersAreNonnullByDefault
    public static void send(CommandSender sender, String message, Object ... args) {
        sender.sendMessage(ChatUtil.color(MessageFormat.format(message, args)));
    }

    @ParametersAreNonnullByDefault
    public static void sendActionBar(Player player, String message, Object ... args) {
        BaseComponent[] components = TextComponent.fromLegacyText((String)ChatUtil.color(MessageFormat.format(message, args)));
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
    }

    private ChatUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

