/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.core.tasks;

import java.util.UUID;
import net.guizhanss.villagertrade.VillagerTrade;

public abstract class ConfirmationTask {
    private final long expireAfter;

    public static void create(final UUID uuid, long expireTime, final Runnable runnable) {
        long expireAfter = System.currentTimeMillis() + expireTime;
        VillagerTrade.getRegistry().getConfirmationTasks().put(uuid, new ConfirmationTask(expireAfter){

            @Override
            void run() {
                runnable.run();
                VillagerTrade.getRegistry().getConfirmationTasks().remove(uuid);
            }
        });
    }

    public final boolean execute() {
        if (System.currentTimeMillis() < this.expireAfter) {
            this.run();
            return true;
        }
        return false;
    }

    abstract void run();

    public ConfirmationTask(long expireAfter) {
        this.expireAfter = expireAfter;
    }

    public long getExpireAfter() {
        return this.expireAfter;
    }
}

