/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.core.commands.subcommands;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.villagertrade.VillagerTrade;
import net.guizhanss.villagertrade.api.trades.TradeConfiguration;
import net.guizhanss.villagertrade.core.commands.subcommands.AdminPlayerCommand;
import net.guizhanss.villagertrade.core.commands.subcommands.TradeKeyCompletion;
import net.guizhanss.villagertrade.core.tasks.ConfirmationTask;
import net.guizhanss.villagertrade.implementation.menu.TradeListMenu;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class RemoveCommand
extends AdminPlayerCommand
implements TradeKeyCompletion {
    public RemoveCommand() {
        super("remove", false, "<tradeKey>");
    }

    @ParametersAreNonnullByDefault
    public static void awaitRemoval(Player player, TradeConfiguration tradeConfig, Runnable callback) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        Preconditions.checkArgument((tradeConfig != null ? 1 : 0) != 0, (Object)"TradeConfiguration cannot be null");
        String tradeKey = tradeConfig.getKey();
        VillagerTrade.getLocalization().sendKeyedMessage((CommandSender)player, "commands.remove.await-confirm", msg -> msg.replace("%tradeKey%", tradeKey));
        ConfirmationTask.create(player.getUniqueId(), 30000L, () -> {
            VillagerTrade.getRegistry().clear(tradeConfig);
            VillagerTrade.getLocalization().sendKeyedMessage((CommandSender)player, "commands.remove.success", msg -> msg.replace("%tradeKey%", tradeKey));
            TradeListMenu.closeAll();
            callback.run();
        });
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onCommand(CommandSender sender, String[] args) {
        if (!this.canExecute(sender, args)) {
            return;
        }
        String tradeKey = args[1];
        TradeConfiguration tradeConfig = VillagerTrade.getRegistry().getTradeConfigurations().get(tradeKey);
        if (tradeConfig == null) {
            VillagerTrade.getLocalization().sendKeyedMessage(sender, "commands.remove.not-found", msg -> msg.replace("%tradeKey%", tradeKey));
            return;
        }
        RemoveCommand.awaitRemoval((Player)sender, tradeConfig, () -> {});
    }

    @Override
    @Nonnull
    @ParametersAreNonnullByDefault
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return this.tabComplete(sender, args, 1);
    }
}

