/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.api.trades;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.villagertrade.VillagerTrade;
import net.guizhanss.villagertrade.api.trades.TradeItem;
import net.guizhanss.villagertrade.api.trades.TraderTypes;
import net.guizhanss.villagertrade.core.Registry;
import net.guizhanss.villagertrade.utils.ConfigUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.MerchantRecipe;

public final class TradeConfiguration {
    private final String key;
    private final TraderTypes traderTypes;
    private final TradeItem output;
    private final TradeItem input1;
    private final TradeItem input2;
    private final int maxUses;
    private final boolean expReward;
    private final int expVillager;
    private final float priceMultiplier;
    private SlimefunAddon addon;
    private RegistrationState state;

    @ParametersAreNonnullByDefault
    @Nullable
    public static TradeConfiguration loadFromConfig(String key, ConfigurationSection section) {
        Preconditions.checkArgument((section != null ? 1 : 0) != 0, (Object)"ConfigurationSection should not be null");
        try {
            return TradeConfiguration.builder().key(key).traderTypes(TraderTypes.loadFromConfig(section.getStringList("traders"))).output(TradeItem.loadFromConfig(section.getConfigurationSection("output"))).input1(TradeItem.loadFromConfig(section.getConfigurationSection("input.1"))).input2(TradeItem.loadFromConfig(section.getConfigurationSection("input.2"))).maxUses(section.getInt("max-uses")).expReward(section.getBoolean("exp-reward")).expVillager(section.getInt("exp-villager")).priceMultiplier((float)section.getDouble("price-multiplier")).state(RegistrationState.UNREGISTERED).build();
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            VillagerTrade.log(Level.SEVERE, ex, "An error has occurred while loading trade configuration", new Object[0]);
            return null;
        }
    }

    @Nullable
    public static TradeConfiguration getByKey(@Nonnull String key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key should not be null");
        return VillagerTrade.getRegistry().getTradeConfigurations().get(key);
    }

    public void saveToConfig(@Nonnull ConfigurationSection section) {
        Preconditions.checkArgument((section != null ? 1 : 0) != 0, (Object)"ConfigurationSection should not be null");
        section.set("traders", this.traderTypes.toStringList());
        this.output.saveToConfig(ConfigUtils.getOrCreateSection(section, "output"));
        this.input1.saveToConfig(ConfigUtils.getOrCreateSection(section, "input.1"));
        this.input2.saveToConfig(ConfigUtils.getOrCreateSection(section, "input.2"));
        section.set("max-uses", (Object)this.maxUses);
        section.set("exp-reward", (Object)this.expReward);
        section.set("exp-villager", (Object)this.expVillager);
        section.set("price-multiplier", (Object)Float.valueOf(this.priceMultiplier));
    }

    public void register(@Nonnull SlimefunAddon addon) {
        if (this.state == RegistrationState.REGISTERED) {
            VillagerTrade.log(Level.SEVERE, "This TradeConfiguration is already registered!", new Object[0]);
            return;
        }
        Registry registry = VillagerTrade.getRegistry();
        this.state = RegistrationState.INVALID;
        if (registry.getTradeConfigurations().containsKey(this.key)) {
            VillagerTrade.log(Level.SEVERE, "TradeConfiguration with same key (" + this.key + ") is already registered!", new Object[0]);
            return;
        }
        if (this.addon != null) {
            VillagerTrade.log(Level.SEVERE, "This TradeConfiguration is already registered! Make sure you do not set 'addon' before registering it.", new Object[0]);
            return;
        }
        if (addon == null || addon.getJavaPlugin() == null) {
            VillagerTrade.log(Level.SEVERE, "SlimefunAddon is invalid! Skipping...", new Object[0]);
            return;
        }
        if (this.output.getType() == TradeItem.TradeItemType.NONE) {
            VillagerTrade.log(Level.SEVERE, "Trade output is not set or invalid, skipping...", new Object[0]);
            return;
        }
        if (this.input1.getType() == TradeItem.TradeItemType.NONE) {
            VillagerTrade.log(Level.SEVERE, "Trade input 1 is not set or invalid, skipping...", new Object[0]);
            return;
        }
        this.state = RegistrationState.REGISTERED;
        this.addon = addon;
        registry.getTradeConfigurations().put(this.key, this);
        if (this.traderTypes.hasWanderingTrader()) {
            registry.getWanderingTraderConfigurations().add(this);
        }
        if (this.traderTypes.hasVillager()) {
            registry.getVillagerConfigurations().add(this);
        }
        if (this.input1.getType() == TradeItem.TradeItemType.SLIMEFUN) {
            this.registerSlimefunItemTrade(this.input1);
        }
        if (this.input2.getType() == TradeItem.TradeItemType.SLIMEFUN) {
            this.registerSlimefunItemTrade(this.input2);
        }
    }

    private void registerSlimefunItemTrade(@Nonnull TradeItem tradeItem) {
        Preconditions.checkArgument((tradeItem != null ? 1 : 0) != 0, (Object)"TradeItem should not be null");
        SlimefunItem sfItem = SlimefunItem.getById((String)tradeItem.getId());
        if (sfItem == null) {
            return;
        }
        VillagerTrade.getRegistry().getSlimefunTradeInputs().add(this.input2);
    }

    @Nullable
    public MerchantRecipe getMerchantRecipe() {
        if (this.state != RegistrationState.REGISTERED) {
            return null;
        }
        MerchantRecipe recipe = new MerchantRecipe(this.output.getItem(), 0, this.maxUses, this.expReward, this.expVillager, this.priceMultiplier);
        recipe.addIngredient(this.input1.getItem());
        if (this.input2.getType() != TradeItem.TradeItemType.NONE) {
            recipe.addIngredient(this.input2.getItem());
        }
        return recipe;
    }

    public boolean isExternalConfig() {
        if (this.state != RegistrationState.REGISTERED) {
            return false;
        }
        return !this.addon.getName().equals(VillagerTrade.getInstance().getName());
    }

    @Nonnull
    public String toString() {
        return "TradeConfiguration(key = " + this.key + ", traderTypes = " + this.traderTypes.toString() + ", output = " + this.output.toString() + ", input1 = " + this.input1.toString() + ", input2 = " + this.input2.toString() + ", maxUses = " + this.maxUses + ", expReward = " + this.expReward + ", expVillager = " + this.expVillager + ", priceMultiplier = " + this.priceMultiplier + ")";
    }

    TradeConfiguration(String key, TraderTypes traderTypes, TradeItem output, TradeItem input1, TradeItem input2, int maxUses, boolean expReward, int expVillager, float priceMultiplier, SlimefunAddon addon, RegistrationState state) {
        this.key = key;
        this.traderTypes = traderTypes;
        this.output = output;
        this.input1 = input1;
        this.input2 = input2;
        this.maxUses = maxUses;
        this.expReward = expReward;
        this.expVillager = expVillager;
        this.priceMultiplier = priceMultiplier;
        this.addon = addon;
        this.state = state;
    }

    public static TradeConfigurationBuilder builder() {
        return new TradeConfigurationBuilder();
    }

    public String getKey() {
        return this.key;
    }

    public TraderTypes getTraderTypes() {
        return this.traderTypes;
    }

    public TradeItem getOutput() {
        return this.output;
    }

    public TradeItem getInput1() {
        return this.input1;
    }

    public TradeItem getInput2() {
        return this.input2;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public boolean isExpReward() {
        return this.expReward;
    }

    public int getExpVillager() {
        return this.expVillager;
    }

    public float getPriceMultiplier() {
        return this.priceMultiplier;
    }

    public SlimefunAddon getAddon() {
        return this.addon;
    }

    public RegistrationState getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TradeConfiguration)) {
            return false;
        }
        TradeConfiguration other = (TradeConfiguration)o;
        if (this.getMaxUses() != other.getMaxUses()) {
            return false;
        }
        if (this.isExpReward() != other.isExpReward()) {
            return false;
        }
        if (this.getExpVillager() != other.getExpVillager()) {
            return false;
        }
        if (Float.compare(this.getPriceMultiplier(), other.getPriceMultiplier()) != 0) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        TraderTypes this$traderTypes = this.getTraderTypes();
        TraderTypes other$traderTypes = other.getTraderTypes();
        if (this$traderTypes == null ? other$traderTypes != null : !this$traderTypes.equals(other$traderTypes)) {
            return false;
        }
        TradeItem this$output = this.getOutput();
        TradeItem other$output = other.getOutput();
        if (this$output == null ? other$output != null : !((Object)this$output).equals(other$output)) {
            return false;
        }
        TradeItem this$input1 = this.getInput1();
        TradeItem other$input1 = other.getInput1();
        if (this$input1 == null ? other$input1 != null : !((Object)this$input1).equals(other$input1)) {
            return false;
        }
        TradeItem this$input2 = this.getInput2();
        TradeItem other$input2 = other.getInput2();
        if (this$input2 == null ? other$input2 != null : !((Object)this$input2).equals(other$input2)) {
            return false;
        }
        SlimefunAddon this$addon = this.getAddon();
        SlimefunAddon other$addon = other.getAddon();
        if (this$addon == null ? other$addon != null : !this$addon.equals(other$addon)) {
            return false;
        }
        RegistrationState this$state = this.getState();
        RegistrationState other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxUses();
        result = result * 59 + (this.isExpReward() ? 79 : 97);
        result = result * 59 + this.getExpVillager();
        result = result * 59 + Float.floatToIntBits(this.getPriceMultiplier());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        TraderTypes $traderTypes = this.getTraderTypes();
        result = result * 59 + ($traderTypes == null ? 43 : $traderTypes.hashCode());
        TradeItem $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
        TradeItem $input1 = this.getInput1();
        result = result * 59 + ($input1 == null ? 43 : ((Object)$input1).hashCode());
        TradeItem $input2 = this.getInput2();
        result = result * 59 + ($input2 == null ? 43 : ((Object)$input2).hashCode());
        SlimefunAddon $addon = this.getAddon();
        result = result * 59 + ($addon == null ? 43 : $addon.hashCode());
        RegistrationState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        return result;
    }

    public static class TradeConfigurationBuilder {
        private String key;
        private TraderTypes traderTypes;
        private TradeItem output;
        private TradeItem input1;
        private TradeItem input2;
        private int maxUses;
        private boolean expReward;
        private int expVillager;
        private float priceMultiplier;
        private SlimefunAddon addon;
        private RegistrationState state;

        TradeConfigurationBuilder() {
        }

        public TradeConfigurationBuilder key(String key) {
            this.key = key;
            return this;
        }

        public TradeConfigurationBuilder traderTypes(TraderTypes traderTypes) {
            this.traderTypes = traderTypes;
            return this;
        }

        public TradeConfigurationBuilder output(TradeItem output) {
            this.output = output;
            return this;
        }

        public TradeConfigurationBuilder input1(TradeItem input1) {
            this.input1 = input1;
            return this;
        }

        public TradeConfigurationBuilder input2(TradeItem input2) {
            this.input2 = input2;
            return this;
        }

        public TradeConfigurationBuilder maxUses(int maxUses) {
            this.maxUses = maxUses;
            return this;
        }

        public TradeConfigurationBuilder expReward(boolean expReward) {
            this.expReward = expReward;
            return this;
        }

        public TradeConfigurationBuilder expVillager(int expVillager) {
            this.expVillager = expVillager;
            return this;
        }

        public TradeConfigurationBuilder priceMultiplier(float priceMultiplier) {
            this.priceMultiplier = priceMultiplier;
            return this;
        }

        public TradeConfigurationBuilder addon(SlimefunAddon addon) {
            this.addon = addon;
            return this;
        }

        public TradeConfigurationBuilder state(RegistrationState state) {
            this.state = state;
            return this;
        }

        public TradeConfiguration build() {
            return new TradeConfiguration(this.key, this.traderTypes, this.output, this.input1, this.input2, this.maxUses, this.expReward, this.expVillager, this.priceMultiplier, this.addon, this.state);
        }

        public String toString() {
            return "TradeConfiguration.TradeConfigurationBuilder(key=" + this.key + ", traderTypes=" + this.traderTypes + ", output=" + this.output + ", input1=" + this.input1 + ", input2=" + this.input2 + ", maxUses=" + this.maxUses + ", expReward=" + this.expReward + ", expVillager=" + this.expVillager + ", priceMultiplier=" + this.priceMultiplier + ", addon=" + this.addon + ", state=" + this.state + ")";
        }
    }

    public static enum RegistrationState {
        UNREGISTERED,
        INVALID,
        REGISTERED;

    }
}

