/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.guizhanlib.updater;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.guizhanss.villagertrade.guizhanlib.updater.AbstractGuizhanBuildsUpdater;
import net.guizhanss.villagertrade.guizhanlib.updater.Locales;
import net.guizhanss.villagertrade.guizhanlib.utils.JsonUtil;

class UpdaterTask
implements Runnable {
    private static boolean DEBUG = false;
    private final AbstractGuizhanBuildsUpdater updater;
    private String workingDirectory;
    private JsonObject repoInfo = null;
    private JsonObject updateInfo = null;

    UpdaterTask(AbstractGuizhanBuildsUpdater updater) {
        this.updater = updater;
    }

    @Override
    public void run() {
        this.getRepoInfo();
        String format = this.getVersionFormat();
        if (format == null) {
            this.updater.log(Level.SEVERE, Locales.INVALID_VERSION, new Object[0]);
            return;
        }
        if (!this.checkVersion(format)) {
            this.updater.log(Level.WARNING, Locales.INVALID_FILE_VERSION, new Object[0]);
            return;
        }
        if (this.hasUpdate()) {
            if (this.updater.getConfig().checkOnly()) {
                this.sendUpdateNotification();
            } else {
                this.update();
            }
        }
    }

    private void getRepoInfo() {
        block6: {
            try {
                URL repos = new URL(this.updater.getReposFileURL());
                JsonObject reposJson = (JsonObject)JsonUtil.parse(this.fetch(repos));
                String key = this.updater.getRepoKey();
                JsonElement currentRepoInfo = JsonUtil.getFromPath(reposJson, key);
                if (currentRepoInfo == null) {
                    JsonArray reposArray = JsonUtil.getFromPath(reposJson, "repos").getAsJsonArray();
                    for (JsonElement repo : reposArray) {
                        JsonObject repoObj = repo.getAsJsonObject();
                        if (!repoObj.has("alias")) continue;
                        for (JsonElement alias : repoObj.get("alias").getAsJsonArray()) {
                            String aliasPrimitive = alias.getAsJsonPrimitive().getAsString();
                            if (!aliasPrimitive.equals(key)) continue;
                            currentRepoInfo = repoObj;
                            break;
                        }
                        if (currentRepoInfo == null) continue;
                        break;
                    }
                }
                if (currentRepoInfo == null) {
                    throw new IllegalStateException("Repository information is not found");
                }
                this.repoInfo = (JsonObject)currentRepoInfo;
                this.workingDirectory = MessageFormat.format("{0}/{1}/{2}", this.updater.getUser(), this.updater.getRepo(), this.updater.getBranch());
            }
            catch (IllegalArgumentException | IllegalStateException | NullPointerException | MalformedURLException ex) {
                this.updater.log(Level.SEVERE, Locales.CANNOT_FIND_REPO, new Object[0]);
                if (!DEBUG) break block6;
                this.updater.log(Level.SEVERE, ex, ex.getMessage(), new Object[0]);
            }
        }
    }

    @Nullable
    private String getVersionFormat() {
        try {
            return JsonUtil.getFromPath(this.repoInfo, "buildOptions.version").getAsString();
        }
        catch (IllegalArgumentException | IllegalStateException | NullPointerException ex) {
            if (DEBUG) {
                this.updater.log(Level.SEVERE, (Exception)ex, ex.getMessage(), new Object[0]);
            }
            return null;
        }
    }

    private boolean checkVersion(String format) {
        if (!this.updater.getConfig().checkVersionFormat()) {
            return true;
        }
        String regex = format.replace("(", "\\(").replace(")", "\\)").replace("{version}", "\\d{1,6}").replace("{git_commit}", "([a-z0-9]{7})").replace("{Year}", "\\d{4}").replace("{year}", "\\d{2}").replace("{Month}", "\\d{2}").replace("{month}", "\\d{1,2}").replace("{Date}", "\\d{2}").replace("{date}", "\\d{1,2}");
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(this.updater.getPlugin().getDescription().getVersion());
        return m.matches();
    }

    private boolean hasUpdate() {
        try {
            boolean needUpdate;
            URL buildsUrl = new URL(this.updater.getBuildsInfo(this.workingDirectory));
            JsonObject buildsJson = (JsonObject)JsonUtil.parse(this.fetch(buildsUrl));
            JsonArray builds = (JsonArray)JsonUtil.getFromPath(buildsJson, "builds");
            JsonObject build = null;
            for (int i = builds.size() - 1; i >= 0 && !(build = (JsonObject)builds.get(i)).get("success").getAsBoolean(); --i) {
                build = null;
            }
            if (build == null) {
                this.updater.log(Level.SEVERE, Locales.CANNOT_FIND_BUILDS, new Object[0]);
                return false;
            }
            String pluginName = JsonUtil.getFromPath(this.repoInfo, "buildOptions.name").getAsString();
            boolean bl = needUpdate = !MessageFormat.format("{0}-{1}.jar", pluginName, this.updater.getPlugin().getDescription().getVersion()).equals(build.get("target").getAsString());
            if (!needUpdate) {
                this.updater.log(Level.INFO, Locales.UP_TO_DATE, this.updater.getPlugin().getName());
                return false;
            }
            this.updateInfo = build;
            return true;
        }
        catch (IllegalArgumentException | IllegalStateException | NullPointerException | MalformedURLException ex) {
            this.updater.log(Level.SEVERE, Locales.CANNOT_FETCH_INFO, new Object[0]);
            if (DEBUG) {
                this.updater.log(Level.SEVERE, ex, ex.getMessage(), new Object[0]);
            }
            return false;
        }
    }

    private void sendUpdateNotification() {
        this.updater.log(Level.INFO, Locales.NEED_UPDATE, this.updater.getPlugin().getName());
        this.updater.log(Level.INFO, Locales.DOWNLOAD_NOTIFICATION, this.updater.getPlugin().getName());
    }

    private void update() {
        String targetFilename = this.updateInfo.get("target").getAsString();
        this.updater.log(Level.INFO, Locales.NEED_UPDATE, this.updater.getPlugin().getName());
        this.updater.log(Level.INFO, Locales.DOWNLOADING, this.updater.getPlugin().getName(), this.updateInfo.get("id").getAsString());
        try {
            int read;
            BufferedInputStream input = new BufferedInputStream(new URL(this.updater.getTargetUrl(this.workingDirectory, targetFilename)).openStream());
            FileOutputStream output = new FileOutputStream(new File("plugins/" + this.updater.getPlugin().getServer().getUpdateFolder(), this.updater.getFile().getName()));
            byte[] data = new byte[1024];
            while ((read = input.read(data, 0, 1024)) != -1) {
                output.write(data, 0, read);
            }
            input.close();
            output.close();
        }
        catch (Exception ex) {
            this.updater.log(Level.SEVERE, Locales.DOWNLOAD_FAIL, this.updater.getPlugin().getName());
            if (DEBUG) {
                this.updater.log(Level.SEVERE, ex, ex.getMessage(), new Object[0]);
            }
            return;
        }
        this.updater.log(Level.INFO, " ", new Object[0]);
        this.updater.log(Level.INFO, Locales.UPDATE_INFO_0, new Object[0]);
        this.updater.log(Level.INFO, Locales.UPDATE_INFO_1, this.updater.getPlugin().getName(), this.updateInfo.get("id").getAsString());
        this.updater.log(Level.INFO, Locales.UPDATE_INFO_2, new Object[0]);
        this.updater.log(Level.INFO, " ", new Object[0]);
    }

    @Nullable
    private String fetch(@Nonnull URL url) {
        try {
            StringBuilder content = new StringBuilder();
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(10000);
            connection.addRequestProperty("User-Agent", "Guizhan Updater");
            connection.setDoOutput(true);
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            String line = reader.readLine();
            while (line != null) {
                content.append(line);
                line = reader.readLine();
            }
            return content.toString();
        }
        catch (IOException | NullPointerException ex) {
            this.updater.log(Level.WARNING, Locales.CANNOT_FETCH_INFO, new Object[0]);
            if (DEBUG) {
                this.updater.log(Level.SEVERE, ex, ex.getMessage(), new Object[0]);
            }
            return null;
        }
    }
}

