/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.guizhanlib.slimefun.addon;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

@ParametersAreNonnullByDefault
public final class Scheduler {
    private final Plugin plugin;

    public Scheduler(@Nonnull Plugin plugin) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin instance cannot be null");
        this.plugin = plugin;
    }

    public void run(@Nonnull Runnable runnable) {
        Bukkit.getScheduler().runTask(this.plugin, runnable);
    }

    public void runAsync(@Nonnull Runnable runnable) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, runnable);
    }

    public void run(int delayTicks, @Nonnull Runnable runnable) {
        Bukkit.getScheduler().runTaskLater(this.plugin, runnable, (long)delayTicks);
    }

    public void runAsync(int delayTicks, @Nonnull Runnable runnable) {
        Bukkit.getScheduler().runTaskLaterAsynchronously(this.plugin, runnable, (long)delayTicks);
    }

    public void repeat(int intervalTicks, @Nonnull Runnable runnable) {
        this.repeat(intervalTicks, 1, runnable);
    }

    public void repeatAsync(int intervalTicks, @Nonnull Runnable runnable) {
        this.repeatAsync(intervalTicks, 1, runnable);
    }

    public void repeat(int intervalTicks, int delayTicks, @Nonnull Runnable runnable) {
        Bukkit.getScheduler().runTaskTimer(this.plugin, runnable, (long)delayTicks, (long)Math.max(1, intervalTicks));
    }

    public void repeatAsync(int intervalTicks, int delayTicks, @Nonnull Runnable runnable) {
        Bukkit.getScheduler().runTaskTimerAsynchronously(this.plugin, runnable, (long)delayTicks, (long)Math.max(1, intervalTicks));
    }
}

