/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.implementation.menu;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import net.guizhanss.villagertrade.VillagerTrade;
import net.guizhanss.villagertrade.api.trades.TradeConfiguration;
import net.guizhanss.villagertrade.implementation.menu.TradeMenu;
import net.guizhanss.villagertrade.utils.ItemUtils;
import net.guizhanss.villagertrade.utils.MenuUtils;
import net.guizhanss.villagertrade.utils.SoundUtils;
import net.guizhanss.villagertrade.utils.Validators;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class TradeListMenu {
    private static final int[] HEADER = new int[]{0, 1, 2, 3, 4, 5, 6, 8};
    private static final int[] FOOTER = new int[]{45, 47, 48, 49, 50, 51, 53};
    private static final int INFO_SLOT = 1;
    private static final int ADD_SLOT = 7;
    private static final int PAGE_SIZE = 36;
    private static final int PAGE_PREVIOUS = 46;
    private static final int PAGE_NEXT = 52;
    private static final String LANG_MENU = "menu.list.";
    private static final Map<UUID, Boolean> OPEN_MAP = new HashMap<UUID, Boolean>();
    private final Player player;
    private final ChestMenu menu;

    public TradeListMenu(@Nonnull Player player) {
        this.player = player;
        this.menu = new ChestMenu(VillagerTrade.getLocalization().getString("menu.list.title"));
        this.setupMenu();
        this.displayPage(1);
        this.menu.open(new Player[]{player});
    }

    public static void closeAll() {
        for (UUID uuid : OPEN_MAP.keySet()) {
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p != null) {
                p.closeInventory();
            }
            OPEN_MAP.remove(uuid);
        }
    }

    private void setupMenu() {
        for (int slot : HEADER) {
            this.menu.addItem(slot, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int slot : FOOTER) {
            this.menu.addItem(slot, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        this.menu.setEmptySlotsClickable(false);
        this.menu.addMenuOpeningHandler(p -> OPEN_MAP.put(p.getUniqueId(), true));
        this.menu.addMenuCloseHandler(p -> OPEN_MAP.remove(p.getUniqueId()));
        this.menu.addItem(1, this.getInfoItem(), ChestMenuUtils.getEmptyClickHandler());
        this.menu.addItem(7, this.getAddItem(), ChestMenuUtils.getEmptyClickHandler());
    }

    private void displayPage(int page) {
        ArrayList<TradeConfiguration> trades = new ArrayList<TradeConfiguration>(VillagerTrade.getRegistry().getTradeConfigurations().values());
        int total = trades.size();
        int totalPages = (int)Math.ceil((double)total / 36.0);
        int start = (page - 1) * 36;
        int end = Math.min(start + 36, total);
        List subList = trades.subList(start, end);
        this.menu.addMenuClickHandler(7, (p, slot, item, action) -> {
            p.closeInventory();
            VillagerTrade.getLocalization().sendKeyedMessage((CommandSender)p, "menu.list.add");
            MenuUtils.awaitInput(p, Validators::notEmpty, input -> new TradeMenu(p, (String)input));
            return false;
        });
        this.setupFooter(page, totalPages);
        SoundUtils.playOpenMenuSound(this.player);
        for (int i = 0; i < 36; ++i) {
            int slot2 = i + 9;
            if (i + 1 <= subList.size()) {
                TradeConfiguration trade = (TradeConfiguration)subList.get(i);
                this.menu.replaceExistingItem(slot2, this.getTradeDisplayItem(trade));
                this.menu.addMenuClickHandler(slot2, (p, slot1, item, action) -> {
                    if (!trade.isExternalConfig()) {
                        new TradeMenu(p, trade);
                    }
                    return false;
                });
                continue;
            }
            this.menu.replaceExistingItem(slot2, null);
            this.menu.addMenuClickHandler(slot2, ChestMenuUtils.getEmptyClickHandler());
        }
    }

    @ParametersAreNonnullByDefault
    private void setupFooter(int page, int totalPages) {
        for (int slot2 : FOOTER) {
            this.menu.replaceExistingItem(slot2, ChestMenuUtils.getBackground());
            this.menu.addMenuClickHandler(slot2, ChestMenuUtils.getEmptyClickHandler());
        }
        this.menu.replaceExistingItem(46, ChestMenuUtils.getPreviousButton((Player)this.player, (int)page, (int)totalPages));
        this.menu.addMenuClickHandler(46, (p, slot, itemStack, clickAction) -> {
            int previousPage = page - 1;
            if (previousPage >= 1) {
                this.displayPage(previousPage);
            }
            return false;
        });
        this.menu.replaceExistingItem(52, ChestMenuUtils.getNextButton((Player)this.player, (int)page, (int)totalPages));
        this.menu.addMenuClickHandler(52, (p, slot, itemStack, clickAction) -> {
            int nextPage = page + 1;
            if (nextPage <= totalPages) {
                this.displayPage(nextPage);
            }
            return false;
        });
    }

    @Nonnull
    private ItemStack getTradeDisplayItem(@Nonnull TradeConfiguration tradeConfig) {
        Preconditions.checkArgument((tradeConfig != null ? 1 : 0) != 0, (Object)"TradeConfiguration cannot be null");
        ItemStack item = MenuUtils.parseVariables(this.getItem(Material.PAPER, "trade"), Map.of("%tradeKey%", tradeConfig.getKey(), "%traderTypes%", tradeConfig.getTraderTypes().toHumanizedString(), "%input1%", tradeConfig.getInput1().toShortString(), "%input2%", tradeConfig.getInput2().toShortString(), "%output%", tradeConfig.getOutput().toShortString(), "%maxUses%", String.valueOf(tradeConfig.getMaxUses()), "%expReward%", String.valueOf(tradeConfig.isExpReward()), "%expVillager%", String.valueOf(tradeConfig.getExpVillager()), "%priceMultiplier%", String.valueOf(tradeConfig.getPriceMultiplier())));
        String pathPrefix = "menu.list.trade.lore-extra.";
        return ItemUtils.addLore(item, VillagerTrade.getLocalization().getStringList(tradeConfig.isExternalConfig() ? pathPrefix + "not-editable" : pathPrefix + "editable"));
    }

    @Nonnull
    private ItemStack getInfoItem() {
        return this.getItem(Material.ENCHANTED_BOOK, "info");
    }

    @Nonnull
    private ItemStack getAddItem() {
        return this.getItem(Material.WRITABLE_BOOK, "add");
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private ItemStack getItem(Material material, String key) {
        return new CustomItemStack(material, VillagerTrade.getLocalization().getString(LANG_MENU + key + ".name"), VillagerTrade.getLocalization().getStringList(LANG_MENU + key + ".lore"));
    }
}

