/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.implementation.managers;

import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.villagertrade.VillagerTrade;
import net.guizhanss.villagertrade.api.trades.TradeConfiguration;
import net.guizhanss.villagertrade.guizhanlib.slimefun.addon.AddonConfig;
import net.guizhanss.villagertrade.utils.ConfigUtils;
import net.guizhanss.villagertrade.utils.Debug;
import org.bukkit.configuration.ConfigurationSection;

public final class ConfigManager {
    private static final String FILE_TRADES = "trades.yml";
    private final VillagerTrade plugin;
    private final AddonConfig config;
    private final AddonConfig trades;
    private boolean isDebug;

    public ConfigManager(@Nonnull VillagerTrade plugin) {
        this.plugin = plugin;
        this.config = (AddonConfig)plugin.getConfig();
        this.trades = new AddonConfig(plugin, FILE_TRADES);
        this.afterReload();
    }

    public void reloadAll() {
        this.config.reload();
        this.trades.reload();
        this.afterReload();
    }

    @ParametersAreNonnullByDefault
    public void saveTrade(TradeConfiguration tradeConfig) {
        tradeConfig.saveToConfig(ConfigUtils.getOrCreateSection((ConfigurationSection)this.trades, tradeConfig.getKey()));
        this.trades.save();
    }

    private void afterReload() {
        ConfigUtils.addMissingOptions(this.config);
        this.isDebug = this.config.getBoolean("debug", false);
        VillagerTrade.getScheduler().run(this::loadTrades);
    }

    private void loadTrades() {
        if (!this.config.getBoolean("enable-trades")) {
            VillagerTrade.log(Level.WARNING, "Trades are disabled in the config!", new Object[0]);
            VillagerTrade.log(Level.WARNING, "You need to set up the trades in trades.yml,", new Object[0]);
            VillagerTrade.log(Level.WARNING, "and enable trades in config.yml.", new Object[0]);
            return;
        }
        VillagerTrade.log(Level.INFO, "Trades are enabled! Loading...", new Object[0]);
        int count = 0;
        List keys = this.trades.getKeys(false).stream().toList();
        int keySize = keys.size();
        for (int i = 0; i < keySize; ++i) {
            String key = (String)keys.get(i);
            Debug.log("Loading trade (" + (i + 1) + "/" + keySize + "): " + key, new Object[0]);
            try {
                TradeConfiguration tradeConfig = TradeConfiguration.loadFromConfig(key, this.trades.getConfigurationSection(key));
                Debug.log("Trade config of " + key + ":", new Object[0]);
                Debug.logRaw(tradeConfig.toString());
                tradeConfig.register(this.plugin);
                if (tradeConfig.getState() != TradeConfiguration.RegistrationState.REGISTERED) continue;
                Debug.log("Successfully registered trade: " + key, new Object[0]);
                ++count;
                continue;
            }
            catch (NullPointerException ex) {
                VillagerTrade.log(Level.SEVERE, "Failed to load trade: " + key + ", invalid config has been provided!", new Object[0]);
                continue;
            }
            catch (Exception ex) {
                VillagerTrade.log(Level.SEVERE, ex, "Failed to load trade: " + key, new Object[0]);
            }
        }
        VillagerTrade.log(Level.INFO, "Successfully loaded " + count + " trades!", new Object[0]);
    }

    public VillagerTrade getPlugin() {
        return this.plugin;
    }

    public AddonConfig getConfig() {
        return this.config;
    }

    public AddonConfig getTrades() {
        return this.trades;
    }

    public boolean isDebug() {
        return this.isDebug;
    }
}

