/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.core.commands.subcommands;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.villagertrade.VillagerTrade;
import net.guizhanss.villagertrade.api.trades.TradeConfiguration;
import net.guizhanss.villagertrade.core.commands.subcommands.AdminPlayerCommand;
import net.guizhanss.villagertrade.core.commands.subcommands.TradeKeyCompletion;
import net.guizhanss.villagertrade.implementation.menu.TradeMenu;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class EditCommand
extends AdminPlayerCommand
implements TradeKeyCompletion {
    public EditCommand() {
        super("edit", false, "<tradeKey>");
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onCommand(CommandSender sender, String[] args) {
        if (!this.canExecute(sender, args)) {
            return;
        }
        Player player = (Player)sender;
        String tradeKey = args[1];
        TradeConfiguration tradeConfig = VillagerTrade.getRegistry().getTradeConfigurations().get(tradeKey);
        if (tradeConfig != null) {
            new TradeMenu(player, tradeConfig);
        } else {
            VillagerTrade.getLocalization().sendKeyedMessage(sender, "commands.edit.not-found", msg -> msg.replace("%tradeKey%", tradeKey));
        }
    }

    @Override
    @Nonnull
    @ParametersAreNonnullByDefault
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return this.tabComplete(sender, args, 1);
    }
}

