/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.core.commands;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.villagertrade.VillagerTrade;
import org.bukkit.command.CommandSender;

public abstract class SubCommand {
    private final String name;
    private final boolean isHidden;

    protected SubCommand(@Nonnull String name, boolean hidden) {
        this.name = name;
        this.isHidden = hidden;
    }

    public boolean isSubCommand(@Nonnull String cmd) {
        return this.name.equalsIgnoreCase(cmd);
    }

    @Nonnull
    public String getDescription() {
        return VillagerTrade.getLocalization().getCommandDescription(this.name);
    }

    @ParametersAreNonnullByDefault
    public abstract void onCommand(CommandSender var1, String[] var2);

    @Nullable
    @ParametersAreNonnullByDefault
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return List.of();
    }

    public String getName() {
        return this.name;
    }

    public boolean isHidden() {
        return this.isHidden;
    }
}

