/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.core;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.villagertrade.api.trades.TradeConfiguration;
import net.guizhanss.villagertrade.api.trades.TradeItem;
import net.guizhanss.villagertrade.core.tasks.ConfirmationTask;

public final class Registry {
    private final Map<String, TradeConfiguration> tradeConfigurations = new LinkedHashMap<String, TradeConfiguration>();
    private final List<TradeConfiguration> wanderingTraderConfigurations = new ArrayList<TradeConfiguration>();
    private final List<TradeConfiguration> villagerConfigurations = new ArrayList<TradeConfiguration>();
    private final Set<TradeItem> slimefunTradeInputs = new HashSet<TradeItem>();
    private final Map<UUID, ConfirmationTask> confirmationTasks = new HashMap<UUID, ConfirmationTask>();

    public void reset() {
        this.tradeConfigurations.clear();
        this.wanderingTraderConfigurations.clear();
        this.villagerConfigurations.clear();
        for (TradeItem item : this.slimefunTradeInputs) {
            SlimefunItem sfItem = SlimefunItem.getById((String)item.getId());
            if (sfItem == null) continue;
        }
        this.slimefunTradeInputs.clear();
    }

    @ParametersAreNonnullByDefault
    public void clear(TradeConfiguration tradeConfig) {
        this.tradeConfigurations.remove(tradeConfig.getKey());
        this.wanderingTraderConfigurations.removeIf(trade -> trade.getKey().equals(tradeConfig.getKey()));
        this.villagerConfigurations.removeIf(trade -> trade.getKey().equals(tradeConfig.getKey()));
    }

    public Map<String, TradeConfiguration> getTradeConfigurations() {
        return this.tradeConfigurations;
    }

    public List<TradeConfiguration> getWanderingTraderConfigurations() {
        return this.wanderingTraderConfigurations;
    }

    public List<TradeConfiguration> getVillagerConfigurations() {
        return this.villagerConfigurations;
    }

    public Set<TradeItem> getSlimefunTradeInputs() {
        return this.slimefunTradeInputs;
    }

    public Map<UUID, ConfirmationTask> getConfirmationTasks() {
        return this.confirmationTasks;
    }
}

