/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.utils;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.villagertrade.guizhanlib.minecraft.utils.ChatUtil;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public final class ItemUtils {
    @Nonnull
    public static ItemStack addGlow(@Nonnull ItemStack item) {
        item.addUnsafeEnchantment(Enchantment.LUCK, 1);
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
        return item;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static ItemStack addLore(ItemStack item, List<String> extraLore) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"item cannot be null");
        Preconditions.checkArgument((extraLore != null ? 1 : 0) != 0, (Object)"extraLore cannot be null");
        Preconditions.checkArgument((boolean)item.hasItemMeta(), (Object)"item meta cannot be null");
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> lore = meta.hasLore() ? meta.getLore() : new ArrayList<String>();
        for (String line : extraLore) {
            lore.add(ChatUtil.color(line));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static boolean canStack(@Nullable ItemStack a, @Nullable ItemStack b) {
        if (a != null && b != null) {
            if (a.getType() == b.getType() && a.hasItemMeta() == b.hasItemMeta()) {
                if (a.hasItemMeta()) {
                    ItemMeta bMeta;
                    ItemMeta aMeta = a.getItemMeta();
                    if (aMeta instanceof Damageable != (bMeta = b.getItemMeta()) instanceof Damageable) {
                        return false;
                    }
                    if (aMeta instanceof Damageable && ((Damageable)aMeta).getDamage() != ((Damageable)bMeta).getDamage()) {
                        return false;
                    }
                    if (aMeta instanceof LeatherArmorMeta != bMeta instanceof LeatherArmorMeta) {
                        return false;
                    }
                    if (aMeta instanceof LeatherArmorMeta && !((LeatherArmorMeta)aMeta).getColor().equals((Object)((LeatherArmorMeta)bMeta).getColor())) {
                        return false;
                    }
                    if (aMeta.hasCustomModelData() != bMeta.hasCustomModelData()) {
                        return false;
                    }
                    if (aMeta.hasCustomModelData() && aMeta.getCustomModelData() != bMeta.getCustomModelData()) {
                        return false;
                    }
                    if (!aMeta.getPersistentDataContainer().equals(bMeta.getPersistentDataContainer())) {
                        return false;
                    }
                    if (!aMeta.getEnchants().equals(bMeta.getEnchants())) {
                        return false;
                    }
                    if (aMeta.hasDisplayName() != bMeta.hasDisplayName()) {
                        return false;
                    }
                    if (aMeta.hasDisplayName() && !aMeta.getDisplayName().equals(bMeta.getDisplayName())) {
                        return false;
                    }
                    if (aMeta.hasLore() != bMeta.hasLore()) {
                        return false;
                    }
                    if (aMeta.hasLore()) {
                        List aLore = aMeta.getLore();
                        List bLore = bMeta.getLore();
                        if (aLore.size() != bLore.size()) {
                            return false;
                        }
                        for (int i = 0; i < aLore.size(); ++i) {
                            if (((String)aLore.get(i)).equals(bLore.get(i))) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private ItemUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

