/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.utils;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.villagertrade.guizhanlib.slimefun.addon.AddonConfig;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public final class ConfigUtils {
    public static void addMissingOptions(@Nonnull AddonConfig config) {
        YamlConfiguration defaultConfig = config.getDefaults();
        for (String key : defaultConfig.getKeys(true)) {
            if (config.contains(key)) continue;
            config.set(key, defaultConfig.get(key));
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static ConfigurationSection getOrCreateSection(ConfigurationSection section, String path) {
        Preconditions.checkArgument((section != null ? 1 : 0) != 0, (Object)"section cannot be null");
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path cannot be null");
        ConfigurationSection newSection = section.getConfigurationSection(path);
        if (newSection == null) {
            newSection = section.createSection(path);
        }
        return newSection;
    }

    private ConfigUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

