/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade;

import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.GitHubBuildsUpdater;
import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import net.guizhanss.villagertrade.bstats.bukkit.Metrics;
import net.guizhanss.villagertrade.core.Registry;
import net.guizhanss.villagertrade.core.services.CustomItemService;
import net.guizhanss.villagertrade.core.services.LocalizationService;
import net.guizhanss.villagertrade.guizhanlib.slimefun.addon.AbstractAddon;
import net.guizhanss.villagertrade.guizhanlib.updater.GuizhanBuildsUpdater;
import net.guizhanss.villagertrade.implementation.managers.CommandManager;
import net.guizhanss.villagertrade.implementation.managers.ConfigManager;
import net.guizhanss.villagertrade.implementation.managers.ListenerManager;
import net.guizhanss.villagertrade.implementation.managers.TaskManager;
import org.bukkit.plugin.Plugin;

public final class VillagerTrade
extends AbstractAddon {
    private LocalizationService localizationService;
    private CustomItemService customItemService;
    private Registry registry;
    private ConfigManager configManager;
    private CommandManager commandManager;
    private ListenerManager listenerManager;
    private TaskManager taskManager;

    public VillagerTrade() {
        super("ybw0014", "VillagerTrade", "master", "auto-update");
    }

    @Nonnull
    public static Registry getRegistry() {
        return VillagerTrade.inst().registry;
    }

    @Nonnull
    public static ConfigManager getConfigManager() {
        return VillagerTrade.inst().configManager;
    }

    @Nonnull
    public static CommandManager getCommandManager() {
        return VillagerTrade.inst().commandManager;
    }

    @Nonnull
    public static ListenerManager getListenerManager() {
        return VillagerTrade.inst().listenerManager;
    }

    @Nonnull
    public static TaskManager getTaskManager() {
        return VillagerTrade.inst().taskManager;
    }

    @Nonnull
    public static LocalizationService getLocalization() {
        return VillagerTrade.inst().localizationService;
    }

    @Nonnull
    public static CustomItemService getCustomItemService() {
        return VillagerTrade.inst().customItemService;
    }

    @Nonnull
    private static VillagerTrade inst() {
        return (VillagerTrade)((Object)VillagerTrade.getInstance());
    }

    @Override
    public void enable() {
        VillagerTrade.log(Level.INFO, "====================", new Object[0]);
        VillagerTrade.log(Level.INFO, "   VillagerTrade    ", new Object[0]);
        VillagerTrade.log(Level.INFO, "     by ybw0014     ", new Object[0]);
        VillagerTrade.log(Level.INFO, "====================", new Object[0]);
        this.registry = new Registry();
        this.localizationService = new LocalizationService(this);
        this.customItemService = new CustomItemService(this);
        this.configManager = new ConfigManager(this);
        this.commandManager = new CommandManager(this);
        this.listenerManager = new ListenerManager(this);
        this.taskManager = new TaskManager();
        this.setupMetrics();
    }

    @Override
    public void disable() {
        this.registry = null;
        this.configManager = null;
        this.listenerManager = null;
    }

    private void setupMetrics() {
        new Metrics(this, 18292);
    }

    @Override
    protected void autoUpdate() {
        if (this.getPluginVersion().startsWith("DEV")) {
            String path = this.getGithubUser() + "/" + this.getGithubRepo() + "/" + this.getGithubBranch();
            new GitHubBuildsUpdater((Plugin)this, this.getFile(), path).start();
        } else if (this.getPluginVersion().startsWith("Build")) {
            try {
                Class<?> clazz = Class.forName("net.guizhanss.villagertrade.guizhanlibplugin.updater.GuizhanUpdater");
                Method updaterStart = clazz.getDeclaredMethod("start", Plugin.class, File.class, String.class, String.class, String.class);
                updaterStart.invoke(null, new Object[]{this, this.getFile(), this.getGithubUser(), this.getGithubRepo(), this.getGithubBranch()});
            }
            catch (Exception ignored) {
                new GuizhanBuildsUpdater((Plugin)this, this.getFile(), this.getGithubUser(), this.getGithubRepo(), this.getGithubBranch()).start();
            }
        }
    }
}

