/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.core.services;

import java.util.List;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.villagertrade.VillagerTrade;
import net.guizhanss.villagertrade.guizhanlib.minecraft.utils.ChatUtil;
import net.guizhanss.villagertrade.guizhanlib.slimefun.addon.AddonConfig;
import org.bukkit.command.CommandSender;

public final class LocalizationService {
    private static final String DEFAULT_PREFIX = "&f[&aVillagerTrade&f]&7 ";
    private static final String FILENAME_LANGUAGE = "lang.yml";
    private final AddonConfig languages;
    private String prefix;

    public LocalizationService(VillagerTrade plugin) {
        this.languages = new AddonConfig(plugin, FILENAME_LANGUAGE);
        this.languages.reload();
        this.afterReload();
    }

    public void reloadAll() {
        this.languages.reload();
        this.afterReload();
    }

    private void afterReload() {
        this.prefix = this.getString("prefix", DEFAULT_PREFIX);
    }

    @Nonnull
    public String getString(@Nonnull String key) {
        return this.getString(key, "");
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public String getString(String key, String def) {
        return this.languages.getString(key, def);
    }

    @Nonnull
    public List<String> getStringList(@Nonnull String key) {
        return this.languages.getStringList(key);
    }

    @Nonnull
    public String getCommandDescription(@Nonnull String command) {
        return this.getString("messages.commands." + command + ".description", "");
    }

    @ParametersAreNonnullByDefault
    public void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(ChatUtil.color(this.prefix + message));
    }

    @ParametersAreNonnullByDefault
    public void sendKeyedMessage(CommandSender sender, String key) {
        this.sendKeyedMessage(sender, key, msg -> msg);
    }

    @ParametersAreNonnullByDefault
    public void sendKeyedMessage(CommandSender sender, String key, UnaryOperator<String> function) {
        this.sendMessage(sender, (String)function.apply(this.getString("messages." + key)));
    }
}

