/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.utils;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.villagertrade.VillagerTrade;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class MenuUtils {
    @Nonnull
    @ParametersAreNonnullByDefault
    public static ItemStack parseVariables(ItemStack item, Map<String, String> map) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"item cannot be null");
        Preconditions.checkArgument((map != null ? 1 : 0) != 0, (Object)"map cannot be null");
        Preconditions.checkArgument((boolean)item.hasItemMeta(), (Object)"item meta cannot be null");
        ItemMeta meta = item.getItemMeta();
        if (meta.hasDisplayName()) {
            String displayName = meta.getDisplayName();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                displayName = displayName.replace(entry.getKey(), entry.getValue());
            }
            meta.setDisplayName(displayName);
        }
        if (meta.hasLore()) {
            List lore = meta.getLore();
            for (int i = 0; i < lore.size(); ++i) {
                String line = (String)lore.get(i);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    line = line.replace(entry.getKey(), entry.getValue());
                }
                lore.set(i, line);
            }
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    @ParametersAreNonnullByDefault
    public static void awaitInput(Player p, Consumer<String> callback) {
        ChatInput.waitForPlayer(VillagerTrade.getInstance(), (Player)p, callback);
    }

    @ParametersAreNonnullByDefault
    public static void awaitInput(Player p, Predicate<String> validator, Consumer<String> successCallback) {
        MenuUtils.awaitInput(p, validator, successCallback, str -> {});
    }

    @ParametersAreNonnullByDefault
    public static void awaitInput(Player p, Predicate<String> validator, Consumer<String> successCallback, Consumer<String> failCallback) {
        ChatInput.waitForPlayer(VillagerTrade.getInstance(), (Player)p, input -> {
            if (validator.test((String)input)) {
                successCallback.accept((String)input);
            } else {
                failCallback.accept((String)input);
                MenuUtils.awaitInput(p, validator, successCallback, failCallback);
            }
        });
    }

    private MenuUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

