/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.core.services;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.villagertrade.VillagerTrade;
import net.guizhanss.villagertrade.utils.ItemUtils;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public final class CustomItemService {
    private static final String FOLDER_ITEMS = "items";
    private final VillagerTrade plugin;
    private final Map<String, ItemStack> customItems = new HashMap<String, ItemStack>();
    private File itemsFolder;

    public CustomItemService(@Nonnull VillagerTrade plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        List customItemIds;
        this.customItems.clear();
        this.itemsFolder = new File(this.plugin.getDataFolder(), FOLDER_ITEMS);
        if (!this.itemsFolder.exists()) {
            try {
                Files.createDirectory(this.itemsFolder.toPath(), new FileAttribute[0]);
            }
            catch (IOException ex) {
                VillagerTrade.log(Level.SEVERE, "Failed to create items folder, custom items will be recognized as NONE.", new Object[0]);
                return;
            }
        }
        try (Stream<Path> fileStream = Files.list(this.itemsFolder.toPath());){
            customItemIds = fileStream.map(Path::toFile).filter(File::isFile).map(File::getName).filter(name -> name.endsWith(".yml")).map(filename -> filename.substring(0, filename.length() - 4)).collect(Collectors.toList());
        }
        catch (IOException ex) {
            VillagerTrade.log(Level.SEVERE, ex, "Failed to load custom items.", new Object[0]);
            return;
        }
        for (String id : customItemIds) {
            ItemStack item = this.loadItem(id);
            this.customItems.put(id, item);
        }
    }

    @Nullable
    public ItemStack getItem(@Nonnull String id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"custom item id cannot be null");
        return this.customItems.get(id);
    }

    @Nullable
    public String getId(@Nullable ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return null;
        }
        if (!item.hasItemMeta()) {
            return null;
        }
        for (Map.Entry<String, ItemStack> entry : this.customItems.entrySet()) {
            if (entry.getValue() == null || !ItemUtils.canStack(item, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public String addItem(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"custom item cannot be null");
        int n = 1;
        while (true) {
            String id;
            if (!this.customItems.containsKey(id = item.getType().name() + "_" + n)) {
                this.addItem(id, item);
                return id;
            }
            ++n;
        }
    }

    @ParametersAreNonnullByDefault
    public void addItem(String id, ItemStack item) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"custom item id cannot be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"custom item cannot be null");
        File itemFile = new File(this.itemsFolder, id + ".yml");
        if (itemFile.exists()) {
            VillagerTrade.log(Level.SEVERE, "Custom item file already exists: " + id, new Object[0]);
            return;
        }
        YamlConfiguration config = new YamlConfiguration();
        config.set("item", (Object)item);
        try {
            config.save(itemFile);
        }
        catch (IOException ex) {
            VillagerTrade.log(Level.SEVERE, ex, "Failed to save custom item file: " + id, new Object[0]);
        }
        this.customItems.put(id, item);
    }

    @Nullable
    private ItemStack loadItem(@Nonnull String id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"custom item id cannot be null");
        File itemFile = new File(this.itemsFolder, id + ".yml");
        if (!itemFile.exists()) {
            VillagerTrade.log(Level.SEVERE, "Custom item file does not exist: " + id, new Object[0]);
            return null;
        }
        return YamlConfiguration.loadConfiguration((File)itemFile).getItemStack("item");
    }
}

