/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.core.commands.subcommands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.villagertrade.VillagerTrade;
import net.guizhanss.villagertrade.api.trades.TradeConfiguration;
import net.guizhanss.villagertrade.core.commands.SubCommand;
import org.bukkit.command.CommandSender;

abstract class TradeKeyCompletionCommand
extends SubCommand {
    protected TradeKeyCompletionCommand(@Nonnull String name, boolean hidden) {
        super(name, hidden);
    }

    @Override
    @ParametersAreNonnullByDefault
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 2) {
            ArrayList<String> result = new ArrayList<String>();
            for (Map.Entry<String, TradeConfiguration> entry : VillagerTrade.getRegistry().getTradeConfigurations().entrySet()) {
                String key = entry.getKey();
                TradeConfiguration config = entry.getValue();
                if (config.isExternalConfig() || !key.startsWith(args[1])) continue;
                result.add(key);
            }
            return result;
        }
        return List.of();
    }
}

