/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.core.commands.subcommands;

import com.google.common.base.Preconditions;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.villagertrade.VillagerTrade;
import net.guizhanss.villagertrade.api.trades.TradeConfiguration;
import net.guizhanss.villagertrade.core.commands.subcommands.TradeKeyCompletionCommand;
import net.guizhanss.villagertrade.core.tasks.ConfirmationTask;
import net.guizhanss.villagertrade.implementation.menu.TradeListMenu;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class RemoveCommand
extends TradeKeyCompletionCommand {
    public RemoveCommand() {
        super("remove", false);
    }

    @ParametersAreNonnullByDefault
    public static void awaitRemoval(Player player, TradeConfiguration tradeConfig, Runnable callback) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        Preconditions.checkArgument((tradeConfig != null ? 1 : 0) != 0, (Object)"TradeConfiguration cannot be null");
        String tradeKey = tradeConfig.getKey();
        VillagerTrade.getLocalization().sendKeyedMessage((CommandSender)player, "commands.remove.await-confirm", msg -> msg.replace("%tradeKey%", tradeKey));
        ConfirmationTask.create(player.getUniqueId(), 30000L, () -> {
            VillagerTrade.getRegistry().clear(tradeConfig);
            VillagerTrade.getLocalization().sendKeyedMessage((CommandSender)player, "commands.remove.success", msg -> msg.replace("%tradeKey%", tradeKey));
            TradeListMenu.closeAll();
            callback.run();
        });
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            VillagerTrade.getLocalization().sendKeyedMessage(sender, "no-console");
            return;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("villagertrade.admin")) {
            VillagerTrade.getLocalization().sendKeyedMessage(sender, "no-permission");
            return;
        }
        if (args.length != 2) {
            VillagerTrade.getLocalization().sendKeyedMessage(sender, "usage", msg -> msg.replace("%usage%", "/sfvt remove <tradeKey>"));
            return;
        }
        String tradeKey = args[1];
        TradeConfiguration tradeConfig = VillagerTrade.getRegistry().getTradeConfigurations().get(tradeKey);
        if (tradeConfig == null) {
            VillagerTrade.getLocalization().sendKeyedMessage(sender, "commands.remove.not-found", msg -> msg.replace("%tradeKey%", tradeKey));
            return;
        }
        RemoveCommand.awaitRemoval(player, tradeConfig, () -> {});
    }
}

