/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.core.commands;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.villagertrade.VillagerTrade;
import net.guizhanss.villagertrade.core.commands.SubCommand;
import net.guizhanss.villagertrade.core.commands.subcommands.AddCommand;
import net.guizhanss.villagertrade.core.commands.subcommands.ConfirmCommand;
import net.guizhanss.villagertrade.core.commands.subcommands.EditCommand;
import net.guizhanss.villagertrade.core.commands.subcommands.ListCommand;
import net.guizhanss.villagertrade.core.commands.subcommands.ReloadCommand;
import net.guizhanss.villagertrade.core.commands.subcommands.RemoveCommand;
import net.guizhanss.villagertrade.core.commands.subcommands.SaveCustomCommand;
import net.guizhanss.villagertrade.guizhanlib.minecraft.utils.ChatUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public final class VtCommand
implements CommandExecutor {
    private final Set<SubCommand> subCommands = new HashSet<SubCommand>();

    public VtCommand() {
        this.subCommands.add(new ListCommand());
        this.subCommands.add(new AddCommand());
        this.subCommands.add(new EditCommand());
        this.subCommands.add(new RemoveCommand());
        this.subCommands.add(new ReloadCommand());
        this.subCommands.add(new ConfirmCommand());
        this.subCommands.add(new SaveCustomCommand());
    }

    @ParametersAreNonnullByDefault
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 0) {
            for (SubCommand subCommand : this.subCommands) {
                if (!subCommand.isSubCommand(args[0])) continue;
                subCommand.onCommand(sender, args);
                return true;
            }
            this.sendHelp(sender);
        } else {
            this.sendHelp(sender);
        }
        return true;
    }

    public void sendHelp(@Nonnull CommandSender sender) {
        sender.sendMessage(ChatUtil.color("&e&lVillagerTrade &6v" + VillagerTrade.getInstance().getPluginVersion()));
        for (SubCommand subCommand : this.subCommands) {
            if (subCommand.isHidden()) continue;
            sender.sendMessage(ChatUtil.color("&e/sfvt " + subCommand.getName() + "&7 - " + subCommand.getDescription()));
        }
    }

    public Set<SubCommand> getSubCommands() {
        return this.subCommands;
    }
}

