/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.villagertrade.api.trades;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.util.Objects;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.guizhanss.villagertrade.VillagerTrade;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public final class TradeItem {
    private static final String KEY_TYPE = "type";
    private static final String KEY_ID = "id";
    private static final String KEY_AMOUNT = "amount";
    private final ItemStack item;
    private final TradeItemType type;
    private final String id;
    private final int amount;

    public TradeItem(@Nonnull String type, @Nullable String id) {
        this(type, id, 1);
    }

    public TradeItem(@Nonnull String type, @Nullable String id, int amount) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"TraderItemType cannot be null");
        this.id = id;
        this.amount = amount;
        TradeItemType tempType = TradeItemType.NONE;
        CustomItemStack tempItem = null;
        switch (type.toUpperCase()) {
            case "VANILLA": {
                try {
                    Material mat = Material.getMaterial((String)id.toUpperCase());
                    tempItem = new ItemStack(mat, amount);
                    tempType = TradeItemType.VANILLA;
                }
                catch (Exception ex) {
                    VillagerTrade.log(Level.SEVERE, "The material " + id + " is not a valid vanilla material", new Object[0]);
                }
                break;
            }
            case "SLIMEFUN": {
                try {
                    tempItem = new CustomItemStack(SlimefunItem.getById((String)id).getItem(), amount);
                    tempType = TradeItemType.SLIMEFUN;
                }
                catch (Exception ex) {
                    VillagerTrade.log(Level.SEVERE, "The id " + id + " is not a valid Slimefun item", new Object[0]);
                }
                break;
            }
            case "CUSTOM": {
                try {
                    tempItem = new CustomItemStack(VillagerTrade.getCustomItemService().getItem(id), amount);
                    tempType = TradeItemType.CUSTOM;
                }
                catch (Exception ex) {
                    VillagerTrade.log(Level.SEVERE, "The id " + id + " is not a valid custom item", new Object[0]);
                }
                break;
            }
            case "NONE": {
                break;
            }
            default: {
                VillagerTrade.log(Level.SEVERE, "The type " + type + " is not a valid item type, setting to NONE", new Object[0]);
            }
        }
        if (tempItem != null && (amount < 1 || amount > tempItem.getMaxStackSize())) {
            VillagerTrade.log(Level.SEVERE, "The amount " + amount + " is not a valid amount for " + id, new Object[0]);
            tempType = TradeItemType.NONE;
            tempItem = null;
        }
        this.type = tempType;
        this.item = tempItem;
    }

    @Nonnull
    public static TradeItem loadFromConfig(@Nonnull ConfigurationSection section) {
        Preconditions.checkArgument((section != null ? 1 : 0) != 0, (Object)"The ConfigurationSection cannot be null");
        String type = section.getString(KEY_TYPE, "NONE");
        String id = section.getString(KEY_ID);
        int amount = section.getInt(KEY_AMOUNT, 1);
        return new TradeItem(type, id, amount);
    }

    @Nonnull
    public static TradeItem loadFromItem(@Nonnull ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"The ItemStack cannot be null");
        return TradeItem.loadFromItem(item, item.getAmount());
    }

    @Nonnull
    public static TradeItem loadFromItem(@Nonnull ItemStack item, int amount) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"The ItemStack cannot be null");
        SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)item);
        if (sfItem != null) {
            return new TradeItem("SLIMEFUN", sfItem.getId(), amount);
        }
        if (item.hasItemMeta()) {
            return new TradeItem("CUSTOM", VillagerTrade.getCustomItemService().getId(item), amount);
        }
        return new TradeItem("VANILLA", item.getType().name(), amount);
    }

    public void saveToConfig(@Nonnull ConfigurationSection section) {
        Preconditions.checkArgument((section != null ? 1 : 0) != 0, (Object)"The ConfigurationSection cannot be null");
        section.set(KEY_TYPE, (Object)this.type.name());
        section.set(KEY_ID, (Object)this.id);
        section.set(KEY_AMOUNT, (Object)this.amount);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TradeItem other = (TradeItem)o;
        return this.type == other.type && Objects.equals(this.id, other.id) && this.amount == other.amount;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id, this.amount});
    }

    @Nonnull
    public String toString() {
        return "TradeItem(type=" + this.type + ", id=" + this.id + ", amount=" + this.amount + ")";
    }

    @Nonnull
    public String toShortString() {
        if (this.type == TradeItemType.NONE) {
            return "NONE";
        }
        return this.type.toString() + ", " + this.id + " x" + this.amount;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public TradeItemType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public int getAmount() {
        return this.amount;
    }

    public static enum TradeItemType {
        VANILLA,
        SLIMEFUN,
        CUSTOM,
        NONE;

    }
}

