/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.ultimategenerators2.core.services;

import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.guizhanss.ultimategenerators2.UltimateGenerators2;
import net.guizhanss.ultimategenerators2.libs.guizhanlib.slimefun.addon.SlimefunLocalization;
import net.guizhanss.ultimategenerators2.utils.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J+\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\r\"\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/guizhanss/ultimategenerators2/core/services/LocalizationService;", "Lnet/guizhanss/ultimategenerators2/libs/guizhanlib/slimefun/addon/SlimefunLocalization;", "plugin", "Lnet/guizhanss/ultimategenerators2/UltimateGenerators2;", "jarFile", "Ljava/io/File;", "(Lnet/guizhanss/ultimategenerators2/UltimateGenerators2;Ljava/io/File;)V", "extractTranslations", "", "getString", "", "key", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "Companion", "UltimateGenerators2"})
public final class LocalizationService
extends SlimefunLocalization {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UltimateGenerators2 plugin;
    @NotNull
    private final File jarFile;
    @NotNull
    private static final String FOLDER_NAME = "lang";

    public LocalizationService(@NotNull UltimateGenerators2 plugin, @NotNull File jarFile) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(jarFile, "jarFile");
        super(plugin);
        this.plugin = plugin;
        this.jarFile = jarFile;
        this.extractTranslations();
    }

    private final void extractTranslations() {
        File translationsFolder = new File(this.plugin.getDataFolder(), FOLDER_NAME);
        if (!translationsFolder.exists()) {
            translationsFolder.mkdirs();
        }
        List<String> translationFiles = FileUtils.INSTANCE.listYmlFilesInJar(this.jarFile, "lang/");
        for (String translationFile : translationFiles) {
            String filePath = FOLDER_NAME + File.separator + translationFile;
            File file = new File(this.plugin.getDataFolder(), filePath);
            if (file.exists()) continue;
            this.plugin.saveResource(filePath, true);
        }
    }

    @NotNull
    public final String getString(@NotNull String key, Object ... args2) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(args2, "args");
        String string = MessageFormat.format(this.getString(key), Arrays.copyOf(args2, args2.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/guizhanss/ultimategenerators2/core/services/LocalizationService$Companion;", "", "()V", "FOLDER_NAME", "", "UltimateGenerators2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

