/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.ultimategenerators2.core.services;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.guizhanss.ultimategenerators2.UltimateGenerators2;
import net.guizhanss.ultimategenerators2.libs.guizhanlib.slimefun.addon.AddonConfig;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0018\u001a\u00020\u0019R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lnet/guizhanss/ultimategenerators2/core/services/ConfigurationService;", "", "plugin", "Lnet/guizhanss/ultimategenerators2/UltimateGenerators2;", "(Lnet/guizhanss/ultimategenerators2/UltimateGenerators2;)V", "<set-?>", "", "autoUpdate", "getAutoUpdate", "()Z", "config", "Lnet/guizhanss/ultimategenerators2/libs/guizhanlib/slimefun/addon/AddonConfig;", "debug", "getDebug", "", "enderCrystalGeneratorEnergyPerCrystal", "getEnderCrystalGeneratorEnergyPerCrystal", "()I", "glassElectricityTransmitterCraftAmount", "getGlassElectricityTransmitterCraftAmount", "", "lang", "getLang", "()Ljava/lang/String;", "reload", "", "UltimateGenerators2"})
public final class ConfigurationService {
    @NotNull
    private final AddonConfig config;
    private boolean autoUpdate;
    private boolean debug;
    @NotNull
    private String lang;
    private int glassElectricityTransmitterCraftAmount;
    private int enderCrystalGeneratorEnergyPerCrystal;

    public ConfigurationService(@NotNull UltimateGenerators2 plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.config = new AddonConfig(plugin, "config.yml");
        this.autoUpdate = true;
        this.lang = "en";
        this.glassElectricityTransmitterCraftAmount = 12;
        this.enderCrystalGeneratorEnergyPerCrystal = 128;
        this.reload();
    }

    public final boolean getAutoUpdate() {
        return this.autoUpdate;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    @NotNull
    public final String getLang() {
        return this.lang;
    }

    public final int getGlassElectricityTransmitterCraftAmount() {
        return this.glassElectricityTransmitterCraftAmount;
    }

    public final int getEnderCrystalGeneratorEnergyPerCrystal() {
        return this.enderCrystalGeneratorEnergyPerCrystal;
    }

    public final void reload() {
        this.config.reload();
        this.config.addMissingKeys();
        this.autoUpdate = this.config.getBoolean("auto-update", true);
        this.debug = this.config.getBoolean("debug", false);
        String string = this.config.getString("lang", "en");
        Intrinsics.checkNotNull(string);
        this.lang = string;
        this.glassElectricityTransmitterCraftAmount = this.config.getInt("glass-electricity-transmitter.craft-amount", 12);
        this.enderCrystalGeneratorEnergyPerCrystal = this.config.getInt("ender-crystal-generator.energy-per-crystal", 128);
        this.config.save();
    }
}

