/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.ultimategenerators2.libs.guizhanlib.updater;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.ultimategenerators2.libs.guizhanlib.updater.LocaleKey;

final class UpdaterLocalizations {
    private static final Map<String, Map<LocaleKey, String>> MAP = new HashMap<String, Map<LocaleKey, String>>();
    private static final Map<LocaleKey, String> LOCALE_EN = new EnumMap<LocaleKey, String>(LocaleKey.class);
    private static final Map<LocaleKey, String> LOCALE_ZH_CN = new EnumMap<LocaleKey, String>(LocaleKey.class);

    @Nonnull
    @ParametersAreNonnullByDefault
    public static String get(String lang, LocaleKey key) {
        Preconditions.checkArgument((lang != null ? 1 : 0) != 0, (Object)"Language cannot be null");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Language key cannot be null");
        Map<LocaleKey, String> localeMap = MAP.get(lang);
        if (localeMap == null) {
            localeMap = MAP.get("en-US");
        }
        return localeMap.get((Object)key);
    }

    private UpdaterLocalizations() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        LOCALE_EN.put(LocaleKey.CANNOT_FIND_REPO, "Cannot find repository in Guizhan Builds. Did you set up updater correctly? Is it down?");
        LOCALE_EN.put(LocaleKey.CANNOT_FETCH_INFO, "Cannot fetch information from Guizhan Builds. Is it down?");
        LOCALE_EN.put(LocaleKey.INVALID_VERSION, "Cannot fetch version format from Guizhan Builds. Is it down?");
        LOCALE_EN.put(LocaleKey.INVALID_FILE_VERSION, "Auto updater has been shut down since this version is not from Guizhan Builds.");
        LOCALE_EN.put(LocaleKey.CANNOT_FIND_BUILDS, "Cannot find successful builds. How did you get this plugin?");
        LOCALE_EN.put(LocaleKey.CANNOT_CALCULATE_CHECKSUM, "Cannot calculate the checksum of this plugin.");
        LOCALE_EN.put(LocaleKey.UP_TO_DATE, "{0} is up to date.");
        LOCALE_EN.put(LocaleKey.NEED_UPDATE, "{0} needs to be updated.");
        LOCALE_EN.put(LocaleKey.DOWNLOAD_NOTIFICATION, "Downloading has been disabled due to check only mode. You will need to download from Guizhan Builds manually.");
        LOCALE_EN.put(LocaleKey.DOWNLOADING, "Downloading {0} - Build {1}.");
        LOCALE_EN.put(LocaleKey.DOWNLOAD_FAIL, "Failed to download the new version of {0}.");
        LOCALE_EN.put(LocaleKey.UPDATE_INFO_0, "============== Auto update ==============");
        LOCALE_EN.put(LocaleKey.UPDATE_INFO_1, "Downloaded {0} - Build {1}");
        LOCALE_EN.put(LocaleKey.UPDATE_INFO_2, "Restart server to install the update");
        LOCALE_ZH_CN.put(LocaleKey.CANNOT_FIND_REPO, "\u65e0\u6cd5\u627e\u5230\u4ed3\u5e93\u4fe1\u606f\u3002\u4f60\u786e\u5b9a\u8bbe\u7f6e\u597d\u4e86\uff1f");
        LOCALE_ZH_CN.put(LocaleKey.CANNOT_FETCH_INFO, "\u65e0\u6cd5\u4ece\u6784\u5efa\u7ad9\u83b7\u53d6\u4fe1\u606f\u3002");
        LOCALE_ZH_CN.put(LocaleKey.INVALID_VERSION, "\u65e0\u6cd5\u4ece\u6784\u5efa\u7ad9\u83b7\u53d6\u7248\u672c\u683c\u5f0f\u4fe1\u606f\u3002");
        LOCALE_ZH_CN.put(LocaleKey.INVALID_FILE_VERSION, "\u81ea\u52a8\u66f4\u65b0\u5df2\u7981\u7528\uff0c\u8be5\u7248\u672c\u4e0d\u662f\u4ece\u9b3c\u65a9\u6784\u5efa\u7ad9\u4e0b\u8f7d\u7684\u3002");
        LOCALE_ZH_CN.put(LocaleKey.CANNOT_FIND_BUILDS, "\u65e0\u6cd5\u627e\u5230\u6210\u529f\u7684\u6784\u5efa\u3002\u4f60\u662f\u600e\u4e48\u83b7\u53d6\u8fd9\u4e2a\u63d2\u4ef6\u7684\u3002");
        LOCALE_ZH_CN.put(LocaleKey.CANNOT_CALCULATE_CHECKSUM, "\u65e0\u6cd5\u8ba1\u7b97\u63d2\u4ef6\u7684\u6821\u9a8c\u548c\u3002");
        LOCALE_ZH_CN.put(LocaleKey.UP_TO_DATE, "{0} \u5df2\u662f\u6700\u65b0\u7248\u672c\u3002");
        LOCALE_ZH_CN.put(LocaleKey.NEED_UPDATE, "{0} \u9700\u8981\u66f4\u65b0\u3002");
        LOCALE_ZH_CN.put(LocaleKey.DOWNLOAD_NOTIFICATION, "\u7531\u4e8e\u5f00\u542f\u4e86\u4ec5\u901a\u77e5\u6a21\u5f0f\uff0c\u4e0b\u8f7d\u66f4\u65b0\u5df2\u7981\u7528\u3002\u4f60\u9700\u8981\u624b\u52a8\u524d\u5f80\u9b3c\u65a9\u6784\u5efa\u7ad9\u4e0b\u8f7d\u66f4\u65b0\u3002");
        LOCALE_ZH_CN.put(LocaleKey.DOWNLOADING, "\u6b63\u5728\u4e0b\u8f7d {0} - \u6784\u5efa #{1}");
        LOCALE_ZH_CN.put(LocaleKey.DOWNLOAD_FAIL, "\u4e0b\u8f7d {0} \u7684\u65b0\u7248\u672c\u5931\u8d25\u3002");
        LOCALE_ZH_CN.put(LocaleKey.UPDATE_INFO_0, "============== \u81ea\u52a8\u66f4\u65b0 ==============");
        LOCALE_ZH_CN.put(LocaleKey.UPDATE_INFO_1, "\u5df2\u4e0b\u8f7d {0} - \u6784\u5efa #{1}");
        LOCALE_ZH_CN.put(LocaleKey.UPDATE_INFO_2, "\u91cd\u542f\u670d\u52a1\u5668\u4ee5\u5b89\u88c5\u65b0\u7248\u672c");
        MAP.put("en-US", LOCALE_EN);
        MAP.put("zh-CN", LOCALE_ZH_CN);
    }
}

