/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.ultimategenerators2.implementation.items.abstracts;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetProvider;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.operations.FuelOperation;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import net.guizhanss.ultimategenerators2.core.recipes.MachineFuel;
import net.guizhanss.ultimategenerators2.implementation.UGItems;
import net.guizhanss.ultimategenerators2.implementation.items.abstracts.AHopper;
import net.guizhanss.ultimategenerators2.libs.guizhanlib.minecraft.utils.ChatUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u001f\u001a\u0004\u0018\u00010\u00192\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100#H\u0004J\b\u0010$\u001a\u00020\u0010H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0&H\u0016J\u0018\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040\u001bH\u0016J\u0012\u0010-\u001a\u00020.2\b\u0010\u0007\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u00103\u001a\u0002002\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000200H$J$\u00107\u001a\u0002002\u0006\u00108\u001a\u00020\u00102\u0006\u00109\u001a\u00020\r2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\rH\u0004J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0010J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0010J\u0018\u0010=\u001a\u0002002\u0006\u0010>\u001a\u00020?2\u0006\u0010 \u001a\u00020!H\u0014R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00108G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00020\rX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006@\u00b2\u0006\n\u0010A\u001a\u00020\rX\u008a\u0084\u0002"}, d2={"Lnet/guizhanss/ultimategenerators2/implementation/items/abstracts/AGenerator;", "Lnet/guizhanss/ultimategenerators2/implementation/items/abstracts/AHopper;", "Lio/github/thebusybiscuit/slimefun4/core/attributes/EnergyNetProvider;", "Lio/github/thebusybiscuit/slimefun4/core/attributes/MachineProcessHolder;", "Lio/github/thebusybiscuit/slimefun4/implementation/operations/FuelOperation;", "itemGroup", "Lio/github/thebusybiscuit/slimefun4/api/items/ItemGroup;", "item", "Lio/github/thebusybiscuit/slimefun4/api/items/SlimefunItemStack;", "recipeType", "Lio/github/thebusybiscuit/slimefun4/api/recipes/RecipeType;", "recipe", "", "Lorg/bukkit/inventory/ItemStack;", "(Lio/github/thebusybiscuit/slimefun4/api/items/ItemGroup;Lio/github/thebusybiscuit/slimefun4/api/items/SlimefunItemStack;Lio/github/thebusybiscuit/slimefun4/api/recipes/RecipeType;[Lorg/bukkit/inventory/ItemStack;)V", "_energyCapacity", "", "_energyProduction", "capacity", "getEnergyCapacity", "()I", "energyProduction", "getEnergyProduction", "fuelTypes", "", "Lnet/guizhanss/ultimategenerators2/core/recipes/MachineFuel;", "processor", "Lio/github/thebusybiscuit/slimefun4/core/machines/MachineProcessor;", "progressBar", "getProgressBar", "()Lorg/bukkit/inventory/ItemStack;", "findRecipe", "menu", "Lme/mrCookieSlime/Slimefun/api/inventory/BlockMenu;", "found", "", "getCapacity", "getDisplayRecipes", "", "getGeneratedOutput", "l", "Lorg/bukkit/Location;", "data", "Lme/mrCookieSlime/CSCoreLibPlugin/Configuration/Config;", "getMachineProcessor", "isBucket", "", "onBreak", "", "e", "Lorg/bukkit/event/block/BlockBreakEvent;", "register", "addon", "Lio/github/thebusybiscuit/slimefun4/api/SlimefunAddon;", "registerDefaultFuelTypes", "registerFuel", "ticks", "fuel", "output", "setCapacity", "setEnergyProduction", "tick", "block", "Lorg/bukkit/block/Block;", "UltimateGenerators2", "lazyProgressBar"})
public abstract class AGenerator
extends AHopper
implements EnergyNetProvider,
MachineProcessHolder<FuelOperation> {
    @JvmField
    @NotNull
    protected final Set<MachineFuel> fuelTypes;
    @JvmField
    @NotNull
    protected final MachineProcessor<FuelOperation> processor;
    private int _energyCapacity;
    private int _energyProduction;

    public AGenerator(@NotNull ItemGroup itemGroup, @NotNull SlimefunItemStack item, @NotNull RecipeType recipeType, @NotNull ItemStack[] recipe) {
        Intrinsics.checkNotNullParameter(itemGroup, "itemGroup");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(recipeType, "recipeType");
        Intrinsics.checkNotNullParameter(recipe, "recipe");
        super(itemGroup, item, recipeType, recipe);
        this.fuelTypes = new HashSet();
        this.processor = new MachineProcessor((MachineProcessHolder)this);
        this._energyCapacity = -1;
        this._energyProduction = -1;
        Lazy lazyProgressBar$delegate = LazyKt.lazy((Function0)new Function0<ItemStack>(this){
            final /* synthetic */ AGenerator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ItemStack invoke() {
                return this.this$0.getProgressBar();
            }
        });
        this.processor.setProgressBar(AGenerator._init_$lambda$0(lazyProgressBar$delegate));
    }

    @JvmName(name="getEnergyCapacity")
    public final int getEnergyCapacity() {
        return this._energyCapacity;
    }

    public final int getEnergyProduction() {
        return this._energyProduction;
    }

    @NotNull
    protected abstract ItemStack getProgressBar();

    public int getCapacity() {
        return this.getEnergyCapacity();
    }

    @NotNull
    public MachineProcessor<FuelOperation> getMachineProcessor() {
        return this.processor;
    }

    @Override
    protected void onBreak(@NotNull BlockBreakEvent e, @NotNull BlockMenu menu) {
        Intrinsics.checkNotNullParameter(e, "e");
        Intrinsics.checkNotNullParameter(menu, "menu");
        super.onBreak(e, menu);
        this.processor.endOperation(menu.getLocation());
    }

    protected abstract void registerDefaultFuelTypes();

    protected final void registerFuel(int ticks, @NotNull ItemStack fuel, @Nullable ItemStack output) {
        Intrinsics.checkNotNullParameter(fuel, "fuel");
        this.fuelTypes.add(new MachineFuel(ticks, fuel, output));
    }

    public static /* synthetic */ void registerFuel$default(AGenerator aGenerator, int n, ItemStack itemStack, ItemStack itemStack2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerFuel");
        }
        if ((n2 & 4) != 0) {
            itemStack2 = null;
        }
        aGenerator.registerFuel(n, itemStack, itemStack2);
    }

    @NotNull
    public List<ItemStack> getDisplayRecipes() {
        List list = new ArrayList();
        for (MachineFuel fuel : this.fuelTypes) {
            ItemStack item = (ItemStack)new CustomItemStack(fuel.getInput().clone(), arg_0 -> AGenerator.getDisplayRecipes$lambda$1(fuel, this, arg_0));
            list.add(item);
        }
        return list;
    }

    @NotNull
    public final AGenerator setCapacity(int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (String)"Capacity must be greater than 0", (Object[])new Object[0]);
        if (this.getState() == ItemState.UNREGISTERED) {
            this._energyCapacity = capacity;
            return this;
        }
        throw new IllegalStateException("You cannot modify the capacity after the Item was registered.".toString());
    }

    @NotNull
    public final AGenerator setEnergyProduction(int energyProduction) {
        Preconditions.checkArgument((energyProduction > 0 ? 1 : 0) != 0, (String)"Energy production must be greater than 0", (Object[])new Object[0]);
        if (this.getState() == ItemState.UNREGISTERED) {
            this._energyProduction = energyProduction;
            return this;
        }
        throw new IllegalStateException("You cannot modify the energy production after the Item was registered.".toString());
    }

    public int getGeneratedOutput(@NotNull Location l, @NotNull Config data) {
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(data, "data");
        BlockMenu inv = BlockStorage.getInventory((Location)l);
        FuelOperation operation = (FuelOperation)this.processor.getOperation(l);
        if (operation != null) {
            if (!operation.isFinished()) {
                this.processor.updateProgressBar(inv, AHopper.getSTATUS_SLOT(), (MachineOperation)operation);
                if (this.isChargeable()) {
                    int charge = this.getCharge(l, data);
                    if (this.getEnergyCapacity() - charge >= this.getEnergyProduction()) {
                        operation.addProgress(1);
                        return this.getEnergyProduction();
                    }
                    return 0;
                }
                operation.addProgress(1);
                return this.getEnergyProduction();
            }
            ItemStack itemStack = operation.getIngredient();
            Intrinsics.checkNotNullExpressionValue(itemStack, "getIngredient(...)");
            ItemStack fuel = itemStack;
            if (this.isBucket(fuel)) {
                int[] nArray = this.getOutputSlots();
                inv.pushItem(new ItemStack(Material.BUCKET), Arrays.copyOf(nArray, nArray.length));
            }
            inv.replaceExistingItem(AHopper.getSTATUS_SLOT(), AHopper.getNOT_WORKING_ITEM());
            this.processor.endOperation(l);
            return 0;
        }
        Map found = new HashMap();
        Intrinsics.checkNotNull(inv);
        MachineFuel fuel = this.findRecipe(inv, found);
        if (fuel != null) {
            for (Map.Entry entry : found.entrySet()) {
                int key = ((Number)entry.getKey()).intValue();
                int value = ((Number)entry.getValue()).intValue();
                inv.consumeItem(key, value);
            }
            this.processor.startOperation(l, (MachineOperation)new FuelOperation(fuel.toSf()));
        }
        return 0;
    }

    private final boolean isBucket(ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemStackWrapper itemStackWrapper = ItemStackWrapper.wrap((ItemStack)item);
        Intrinsics.checkNotNullExpressionValue(itemStackWrapper, "wrap(...)");
        ItemStackWrapper wrapper = itemStackWrapper;
        return item.getType() == Material.LAVA_BUCKET || SlimefunUtils.isItemSimilar((ItemStack)((ItemStack)wrapper), (ItemStack)((ItemStack)SlimefunItems.FUEL_BUCKET), (boolean)false) || SlimefunUtils.isItemSimilar((ItemStack)((ItemStack)wrapper), (ItemStack)((ItemStack)SlimefunItems.OIL_BUCKET), (boolean)false) || SlimefunUtils.isItemSimilar((ItemStack)((ItemStack)wrapper), (ItemStack)((ItemStack)UGItems.INSTANCE.getBIOFUEL_BUCKET()), (boolean)false) || SlimefunUtils.isItemSimilar((ItemStack)((ItemStack)wrapper), (ItemStack)((ItemStack)UGItems.INSTANCE.getBIOMASS_BUCKET()), (boolean)false) || SlimefunUtils.isItemSimilar((ItemStack)((ItemStack)wrapper), (ItemStack)((ItemStack)UGItems.INSTANCE.getDIESEL_BUCKET()), (boolean)false);
    }

    @Nullable
    protected final MachineFuel findRecipe(@NotNull BlockMenu menu, @NotNull Map<Integer, Integer> found) {
        Intrinsics.checkNotNullParameter(menu, "menu");
        Intrinsics.checkNotNullParameter(found, "found");
        for (MachineFuel fuel : this.fuelTypes) {
            for (int slot : this.getInputSlots()) {
                if (!fuel.test(menu.getItemInSlot(slot))) continue;
                Integer n = slot;
                found.put(n, fuel.getInput().getAmount());
                return fuel;
            }
        }
        return null;
    }

    public void register(@NotNull SlimefunAddon addon) {
        Intrinsics.checkNotNullParameter(addon, "addon");
        Preconditions.checkArgument((this._energyCapacity > 0 ? 1 : 0) != 0, (String)"Energy capacity must be greater than 0", (Object[])new Object[0]);
        Preconditions.checkArgument((this._energyProduction > 0 ? 1 : 0) != 0, (String)"Energy production must be greater than 0", (Object[])new Object[0]);
        Preconditions.checkArgument((this._energyCapacity >= this.getEnergyProduction() ? 1 : 0) != 0, (String)"Energy capacity must be greater than or equal to energy production", (Object[])new Object[0]);
        super.register(addon);
        this.registerDefaultFuelTypes();
    }

    @Override
    protected void tick(@NotNull Block block, @NotNull BlockMenu menu) {
        Intrinsics.checkNotNullParameter(block, "block");
        Intrinsics.checkNotNullParameter(menu, "menu");
    }

    private static final ItemStack _init_$lambda$0(Lazy<? extends ItemStack> $lazyProgressBar$delegate) {
        Lazy<? extends ItemStack> lazy = $lazyProgressBar$delegate;
        return lazy.getValue();
    }

    private static final void getDisplayRecipes$lambda$1(MachineFuel $fuel, AGenerator this$0, ItemMeta im) {
        Intrinsics.checkNotNullParameter($fuel, "$fuel");
        Intrinsics.checkNotNullParameter((Object)this$0, "this$0");
        Intrinsics.checkNotNullParameter(im, "im");
        String[] stringArray = new String[]{"&8\u21e8 &7\u23f2 " + NumberUtils.getTimeLeft((int)($fuel.getTicks() / 2)), "&8\u21e8 &e\u26a1 &7" + this$0.getEnergyProduction() + " J/t", "&8\u21e8 &e\u26a1 &7" + NumberUtils.getCompactDouble((double)((double)$fuel.getTicks() * (double)this$0.getEnergyProduction())) + " J in total"};
        List<String> lore = CollectionsKt.listOf(stringArray);
        im.setLore(ChatUtil.color(lore));
    }
}

