/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.ultimategenerators2.implementation.items.abstracts;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.operations.CraftingOperation;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import net.guizhanss.ultimategenerators2.core.recipes.MachineRecipe;
import net.guizhanss.ultimategenerators2.core.recipes.SingleMachineRecipe;
import net.guizhanss.ultimategenerators2.core.recipes.SingleOutputMachineRecipe;
import net.guizhanss.ultimategenerators2.implementation.items.abstracts.AHopper;
import net.guizhanss.ultimategenerators2.utils.BlockUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020!H\u0004J\b\u0010\"\u001a\u00020\u0010H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018H\u0016J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020!H\u0014J\u0010\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020)H$J1\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020\u00102\f\u00103\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0004\u00a2\u0006\u0002\u00105J+\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020\u00102\f\u00103\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u00106\u001a\u00020\rH\u0004\u00a2\u0006\u0002\u00107J \u00101\u001a\u00020)2\u0006\u00102\u001a\u00020\u00102\u0006\u00108\u001a\u00020\r2\u0006\u00106\u001a\u00020\rH\u0004J\u000e\u00109\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0010J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0010J\u0018\u0010;\u001a\u00020)2\u0006\u0010<\u001a\u00020=2\u0006\u0010,\u001a\u00020!H\u0014R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00108G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00188\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\rX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>\u00b2\u0006\n\u0010?\u001a\u00020\rX\u008a\u0084\u0002"}, d2={"Lnet/guizhanss/ultimategenerators2/implementation/items/abstracts/AMachine;", "Lnet/guizhanss/ultimategenerators2/implementation/items/abstracts/AHopper;", "Lio/github/thebusybiscuit/slimefun4/core/attributes/EnergyNetComponent;", "Lio/github/thebusybiscuit/slimefun4/core/attributes/MachineProcessHolder;", "Lio/github/thebusybiscuit/slimefun4/implementation/operations/CraftingOperation;", "itemGroup", "Lio/github/thebusybiscuit/slimefun4/api/items/ItemGroup;", "item", "Lio/github/thebusybiscuit/slimefun4/api/items/SlimefunItemStack;", "recipeType", "Lio/github/thebusybiscuit/slimefun4/api/recipes/RecipeType;", "recipe", "", "Lorg/bukkit/inventory/ItemStack;", "(Lio/github/thebusybiscuit/slimefun4/api/items/ItemGroup;Lio/github/thebusybiscuit/slimefun4/api/items/SlimefunItemStack;Lio/github/thebusybiscuit/slimefun4/api/recipes/RecipeType;[Lorg/bukkit/inventory/ItemStack;)V", "_energyCapacity", "", "_energyConsumption", "capacity", "getEnergyCapacity", "()I", "energyConsumption", "getEnergyConsumption", "processor", "Lio/github/thebusybiscuit/slimefun4/core/machines/MachineProcessor;", "progressBar", "getProgressBar", "()Lorg/bukkit/inventory/ItemStack;", "recipes", "", "Lnet/guizhanss/ultimategenerators2/core/recipes/MachineRecipe;", "findNextRecipe", "inv", "Lme/mrCookieSlime/Slimefun/api/inventory/BlockMenu;", "getCapacity", "getDisplayRecipes", "", "getEnergyComponentType", "Lio/github/thebusybiscuit/slimefun4/core/networks/energy/EnergyNetComponentType;", "getMachineProcessor", "onBreak", "", "e", "Lorg/bukkit/event/block/BlockBreakEvent;", "menu", "register", "addon", "Lio/github/thebusybiscuit/slimefun4/api/SlimefunAddon;", "registerDefaultRecipes", "registerRecipe", "ticks", "inputs", "outputs", "(I[Lorg/bukkit/inventory/ItemStack;[Lorg/bukkit/inventory/ItemStack;)V", "output", "(I[Lorg/bukkit/inventory/ItemStack;Lorg/bukkit/inventory/ItemStack;)V", "input", "setCapacity", "setEnergyConsumption", "tick", "b", "Lorg/bukkit/block/Block;", "UltimateGenerators2", "lazyProgressBar"})
public abstract class AMachine
extends AHopper
implements EnergyNetComponent,
MachineProcessHolder<CraftingOperation> {
    @JvmField
    @NotNull
    protected final List<MachineRecipe> recipes;
    @JvmField
    @NotNull
    protected final MachineProcessor<CraftingOperation> processor;
    private int _energyCapacity;
    private int _energyConsumption;

    public AMachine(@NotNull ItemGroup itemGroup, @NotNull SlimefunItemStack item, @NotNull RecipeType recipeType, @NotNull ItemStack[] recipe) {
        Intrinsics.checkNotNullParameter(itemGroup, "itemGroup");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(recipeType, "recipeType");
        Intrinsics.checkNotNullParameter(recipe, "recipe");
        super(itemGroup, item, recipeType, recipe);
        this.recipes = new ArrayList();
        this.processor = new MachineProcessor((MachineProcessHolder)this);
        this._energyCapacity = -1;
        this._energyConsumption = -1;
        Lazy lazyProgressBar$delegate = LazyKt.lazy((Function0)new Function0<ItemStack>(this){
            final /* synthetic */ AMachine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ItemStack invoke() {
                return this.this$0.getProgressBar();
            }
        });
        this.processor.setProgressBar(AMachine._init_$lambda$0(lazyProgressBar$delegate));
    }

    @JvmName(name="getEnergyCapacity")
    public final int getEnergyCapacity() {
        return this._energyCapacity;
    }

    public final int getEnergyConsumption() {
        return this._energyConsumption;
    }

    @NotNull
    protected abstract ItemStack getProgressBar();

    public int getCapacity() {
        return this.getEnergyCapacity();
    }

    @NotNull
    public MachineProcessor<CraftingOperation> getMachineProcessor() {
        return this.processor;
    }

    @Override
    protected void onBreak(@NotNull BlockBreakEvent e, @NotNull BlockMenu menu) {
        Intrinsics.checkNotNullParameter(e, "e");
        Intrinsics.checkNotNullParameter(menu, "menu");
        super.onBreak(e, menu);
        this.processor.endOperation(menu.getLocation());
    }

    @NotNull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    @NotNull
    public final AMachine setCapacity(int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (String)"Capacity must be greater than 0", (Object[])new Object[0]);
        if (this.getState() == ItemState.UNREGISTERED) {
            this._energyCapacity = capacity;
            return this;
        }
        throw new IllegalStateException("You cannot modify the capacity after the Item was registered.".toString());
    }

    @NotNull
    public final AMachine setEnergyConsumption(int energyConsumption) {
        Preconditions.checkArgument((energyConsumption > 0 ? 1 : 0) != 0, (String)"Energy consumption must be greater than 0", (Object[])new Object[0]);
        if (this.getState() == ItemState.UNREGISTERED) {
            this._energyConsumption = energyConsumption;
            return this;
        }
        throw new IllegalStateException("You cannot modify the energy consumption after the Item was registered.".toString());
    }

    protected abstract void registerDefaultRecipes();

    @NotNull
    public List<ItemStack> getDisplayRecipes() {
        List list = new ArrayList();
        for (MachineRecipe recipe : this.recipes) {
            int length = Math.max(recipe.getInput().length, recipe.getOutput().length);
            Intrinsics.checkNotNullExpressionValue(Arrays.copyOf(recipe.getInput(), length), "copyOf(...)");
            Intrinsics.checkNotNullExpressionValue(Arrays.copyOf(recipe.getOutput(), length), "copyOf(...)");
            for (int i = 0; i < length; ++i) {
                ItemStack[] outputs;
                ItemStack[] inputs;
                ItemStack itemStack = inputs[i];
                if (itemStack == null) {
                    itemStack = new ItemStack(Material.AIR);
                }
                list.add(itemStack);
                ItemStack itemStack2 = outputs[i];
                if (itemStack2 == null) {
                    itemStack2 = new ItemStack(Material.AIR);
                }
                list.add(itemStack2);
            }
        }
        return list;
    }

    protected final void registerRecipe(int ticks, @NotNull ItemStack[] inputs, @NotNull ItemStack[] outputs) {
        Intrinsics.checkNotNullParameter(inputs, "inputs");
        Intrinsics.checkNotNullParameter(outputs, "outputs");
        this.recipes.add(new MachineRecipe(ticks, inputs, outputs));
    }

    protected final void registerRecipe(int ticks, @NotNull ItemStack[] inputs, @NotNull ItemStack output) {
        Intrinsics.checkNotNullParameter(inputs, "inputs");
        Intrinsics.checkNotNullParameter(output, "output");
        this.recipes.add(new SingleOutputMachineRecipe(ticks, inputs, output));
    }

    protected final void registerRecipe(int ticks, @NotNull ItemStack input, @NotNull ItemStack output) {
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(output, "output");
        this.recipes.add(new SingleMachineRecipe(ticks, input, output));
    }

    @Override
    protected void tick(@NotNull Block b, @NotNull BlockMenu menu) {
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(menu, "menu");
        BlockMenu blockMenu = BlockStorage.getInventory((Block)b);
        Intrinsics.checkNotNullExpressionValue(blockMenu, "getInventory(...)");
        BlockMenu inv = blockMenu;
        CraftingOperation currentOperation = (CraftingOperation)this.processor.getOperation(b);
        if (currentOperation != null) {
            EnergyNetComponent energyNetComponent = this;
            Location location = b.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            if (BlockUtils.INSTANCE.takeCharge(energyNetComponent, location, this.getEnergyConsumption())) {
                if (!currentOperation.isFinished()) {
                    this.processor.updateProgressBar(inv, AHopper.getSTATUS_SLOT(), (MachineOperation)currentOperation);
                    currentOperation.addProgress(1);
                } else {
                    inv.replaceExistingItem(AHopper.getSTATUS_SLOT(), AHopper.getNOT_WORKING_ITEM());
                    ItemStack[] itemStackArray = currentOperation.getResults();
                    Intrinsics.checkNotNullExpressionValue(itemStackArray, "getResults(...)");
                    for (ItemStack output : itemStackArray) {
                        int[] nArray = this.getOutputSlots();
                        inv.pushItem(output.clone(), Arrays.copyOf(nArray, nArray.length));
                    }
                    this.processor.endOperation(b);
                }
            }
        } else {
            MachineRecipe next = this.findNextRecipe(inv);
            if (next != null) {
                this.processor.startOperation(b, (MachineOperation)new CraftingOperation(next.toSf()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final MachineRecipe findNextRecipe(@NotNull BlockMenu inv) {
        Intrinsics.checkNotNullParameter(inv, "inv");
        Map inventory = new HashMap();
        for (int slot : this.getInputSlots()) {
            ItemStackWrapper itemStackWrapper;
            ItemStack itemStack = inv.getItemInSlot(slot);
            if (itemStack == null) continue;
            Map map = inventory;
            Integer n = slot;
            Intrinsics.checkNotNullExpressionValue(ItemStackWrapper.wrap((ItemStack)itemStack), "wrap(...)");
            map.put(n, itemStackWrapper);
        }
        Map found = new HashMap();
        for (MachineRecipe recipe : this.recipes) {
            void entry;
            Object object = recipe.getInput();
            boolean bl = false;
            int n = ((ItemStack[])object).length;
            while (entry < n) {
                ItemStack input = object[entry];
                for (int slot : this.getInputSlots()) {
                    if (!SlimefunUtils.isItemSimilar((ItemStack)((ItemStack)inventory.get(slot)), (ItemStack)input, (boolean)false)) continue;
                    Integer n2 = slot;
                    found.put(n2, input.getAmount());
                    break;
                }
                ++entry;
            }
            if (found.size() == recipe.getInput().length) {
                object = this.getOutputSlots();
                if (!InvUtils.fitAll((Inventory)inv.toInventory(), (ItemStack[])recipe.getOutput(), (int[])Arrays.copyOf((int[])object, ((ItemStack[])object).length))) {
                    return null;
                }
                for (Map.Entry entry2 : found.entrySet()) {
                    int key = ((Number)entry2.getKey()).intValue();
                    int value = ((Number)entry2.getValue()).intValue();
                    inv.consumeItem(key, value);
                }
                return recipe;
            }
            found.clear();
        }
        return null;
    }

    public void register(@NotNull SlimefunAddon addon) {
        Intrinsics.checkNotNullParameter(addon, "addon");
        Preconditions.checkArgument((this._energyCapacity > 0 ? 1 : 0) != 0, (String)"Energy capacity must be greater than 0", (Object[])new Object[0]);
        Preconditions.checkArgument((this._energyConsumption > 0 ? 1 : 0) != 0, (String)"Energy consumption must be greater than 0", (Object[])new Object[0]);
        Preconditions.checkArgument((this._energyConsumption <= this._energyCapacity ? 1 : 0) != 0, (String)"Energy consumption must be less than or equal to the energy capacity", (Object[])new Object[0]);
        super.register(addon);
        this.registerDefaultRecipes();
    }

    private static final ItemStack _init_$lambda$0(Lazy<? extends ItemStack> $lazyProgressBar$delegate) {
        Lazy<? extends ItemStack> lazy = $lazyProgressBar$delegate;
        return lazy.getValue();
    }
}

