/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.ultimategenerators2.utils;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.jar.JarEntry;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.guizhanss.ultimategenerators2.libs.guizhanlib.utils.FileUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lnet/guizhanss/ultimategenerators2/utils/FileUtils;", "", "()V", "listYmlFilesInJar", "", "", "jarFile", "Ljava/io/File;", "folderName", "UltimateGenerators2"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();

    private FileUtils() {
    }

    @NotNull
    public final List<String> listYmlFilesInJar(@NotNull File jarFile, @NotNull String folderName) {
        List<String> list;
        Intrinsics.checkNotNullParameter(jarFile, "jarFile");
        Intrinsics.checkNotNullParameter(folderName, "folderName");
        try {
            list = FileUtil.listJarEntries(jarFile, (arg_0, arg_1) -> FileUtils.listYmlFilesInJar$lambda$0(folderName, arg_0, arg_1), (arg_0, arg_1) -> FileUtils.listYmlFilesInJar$lambda$1(folderName, arg_0, arg_1));
            Intrinsics.checkNotNull(list);
        }
        catch (IOException e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final boolean listYmlFilesInJar$lambda$0(String $folderName, String entryName, JarEntry entry) {
        Intrinsics.checkNotNullParameter($folderName, "$folderName");
        Intrinsics.checkNotNullParameter(entryName, "entryName");
        Intrinsics.checkNotNullParameter(entry, "entry");
        return StringsKt.startsWith$default(entryName, $folderName + "/", false, 2, null) && !entry.isDirectory() && StringsKt.endsWith$default(entryName, ".yml", false, 2, null);
    }

    private static final String listYmlFilesInJar$lambda$1(String $folderName, String entryName, JarEntry jarEntry) {
        Intrinsics.checkNotNullParameter($folderName, "$folderName");
        Intrinsics.checkNotNullParameter(entryName, "entryName");
        Intrinsics.checkNotNullParameter(jarEntry, "<anonymous parameter 1>");
        return StringsKt.replace$default(entryName, $folderName + "/", "", false, 4, null);
    }
}

