/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.ultimategenerators2.core.services;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import java.io.File;
import java.util.List;
import java.util.Optional;
import net.guizhanss.slimefuntranslation.api.config.TranslationConfiguration;
import net.guizhanss.slimefuntranslation.api.config.TranslationConfigurationFields;
import net.guizhanss.slimefuntranslation.utils.FileUtils;
import net.guizhanss.ultimategenerators2.UltimateGenerators2;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public final class IntegrationService {
    private final UltimateGenerators2 plugin;
    private boolean slimefunTranslationEnabled = false;

    public IntegrationService(UltimateGenerators2 plugin) {
        this.plugin = plugin;
        if (this.isPluginEnabled("SlimefunTranslation")) {
            this.slimefunTranslationEnabled = true;
        }
    }

    private boolean isPluginEnabled(String pluginName) {
        return this.plugin.getServer().getPluginManager().isPluginEnabled(pluginName);
    }

    public void loadTranslations() {
        TranslationConfigurationFields fields = TranslationConfigurationFields.builder().items("items").build();
        List languages = FileUtils.listYamlFiles((File)new File(this.plugin.getDataFolder(), "lang"));
        for (String langFile : languages) {
            File file = new File(this.plugin.getDataFolder(), "lang" + File.separator + langFile);
            String lang = langFile.replace(".yml", "");
            YamlConfiguration fileConfig = YamlConfiguration.loadConfiguration((File)file);
            Optional cfg = TranslationConfiguration.fromFileConfiguration((String)lang, (FileConfiguration)fileConfig, (TranslationConfigurationFields)fields);
            cfg.ifPresent(translationConfiguration -> translationConfiguration.register((SlimefunAddon)this.plugin));
        }
    }

    public boolean isSlimefunTranslationEnabled() {
        return this.slimefunTranslationEnabled;
    }
}

