/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.ultimategenerators2.implementation.items.generators.modular.ender_crystal;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import net.guizhanss.ultimategenerators2.UltimateGenerators2;
import net.guizhanss.ultimategenerators2.utils.EnergyNetUtils;
import net.guizhanss.ultimategenerators2.utils.LocationUtils;
import net.guizhanss.ultimategenerators2.utils.RandomUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class EnderCrystalStabilizer
extends SimpleSlimefunItem<BlockTicker>
implements EnergyNetComponent {
    private static final Map<BlockPosition, Integer> FAILED_TIMES = new HashMap<BlockPosition, Integer>();
    private int energyCapacity = -1;
    private int energyConsumption = -1;

    @ParametersAreNonnullByDefault
    public EnderCrystalStabilizer(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return this.energyCapacity;
    }

    @Nonnull
    public final EnderCrystalStabilizer setCapacity(int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"Capacity must be greater than 0");
        if (this.getState() == ItemState.UNREGISTERED) {
            this.energyCapacity = capacity;
            return this;
        }
        throw new IllegalStateException("You cannot modify the capacity after the Item was registered.");
    }

    @Nonnull
    public final EnderCrystalStabilizer setEnergyConsumption(int energyConsumption) {
        Preconditions.checkArgument((energyConsumption > 0 ? 1 : 0) != 0, (Object)"Energy consumption must be greater than 0");
        if (this.getState() == ItemState.UNREGISTERED) {
            this.energyConsumption = energyConsumption;
            return this;
        }
        throw new IllegalStateException("You cannot modify the energy consumption after the Item was registered.");
    }

    @Nonnull
    public BlockTicker getItemHandler() {
        return new BlockTicker(){

            public void tick(Block b, SlimefunItem sf, Config data) {
                EnderCrystalStabilizer.this.tick(b);
            }

            public boolean isSynchronized() {
                return false;
            }
        };
    }

    public void register(@Nonnull SlimefunAddon addon) {
        Preconditions.checkArgument((this.energyCapacity > 0 ? 1 : 0) != 0, (Object)"Energy capacity must be greater than 0");
        Preconditions.checkArgument((this.energyConsumption > 0 ? 1 : 0) != 0, (Object)"Energy consumption must be greater than 0");
        Preconditions.checkArgument((this.energyCapacity >= this.energyConsumption ? 1 : 0) != 0, (Object)"Energy capacity must be greater than or equal to energy consumption");
        super.register(addon);
    }

    private void tick(@Nonnull Block b) {
        BlockPosition pos = new BlockPosition(b);
        if (!EnergyNetUtils.takeCharge(this, b.getLocation(), this.getEnergyConsumption())) {
            FAILED_TIMES.putIfAbsent(pos, 0);
            FAILED_TIMES.put(pos, FAILED_TIMES.get(pos) + 1);
            if (FAILED_TIMES.get(pos) >= 5) {
                UltimateGenerators2.getScheduler().run(() -> {
                    FAILED_TIMES.remove(pos);
                    BlockStorage.clearBlockInfo((Block)b);
                    b.setType(Material.AIR);
                    b.getWorld().createExplosion(LocationUtils.getBlockCenter(b.getLocation()), 0.0f, false);
                    if (RandomUtils.nextBoolean()) {
                        b.setType(Material.LAVA);
                    }
                    if (RandomUtils.nextBoolean()) {
                        b.getWorld().createExplosion(LocationUtils.getBlockCenter(b.getLocation()), RandomUtils.nextFloat(1.0f, 8.0f), RandomUtils.nextBoolean());
                    }
                });
            }
        }
    }

    public int getEnergyConsumption() {
        return this.energyConsumption;
    }
}

