/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.ultimategenerators2.implementation.items.abstracts;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.operations.CraftingOperation;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import net.guizhanss.ultimategenerators2.core.recipes.MachineRecipe;
import net.guizhanss.ultimategenerators2.core.recipes.SingleMachineRecipe;
import net.guizhanss.ultimategenerators2.core.recipes.SingleOutputMachineRecipe;
import net.guizhanss.ultimategenerators2.implementation.items.abstracts.AHopper;
import net.guizhanss.ultimategenerators2.utils.EnergyNetUtils;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class AMachine
extends AHopper
implements EnergyNetComponent,
MachineProcessHolder<CraftingOperation> {
    protected final List<MachineRecipe> recipes = new ArrayList<MachineRecipe>();
    private final MachineProcessor<CraftingOperation> processor = new MachineProcessor((MachineProcessHolder)this);
    private int energyCapacity = -1;
    private int energyConsumption = -1;

    @ParametersAreNonnullByDefault
    protected AMachine(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.processor.setProgressBar(this.getProgressBar());
    }

    public abstract ItemStack getProgressBar();

    @Nonnull
    public final MachineProcessor<CraftingOperation> getMachineProcessor() {
        return this.processor;
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void onBreak(BlockBreakEvent e, BlockMenu menu) {
        super.onBreak(e, menu);
        this.processor.endOperation(menu.getLocation());
    }

    @Nonnull
    public final EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return this.energyCapacity;
    }

    @Nonnull
    public final AMachine setCapacity(int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"Capacity must be greater than 0");
        if (this.getState() == ItemState.UNREGISTERED) {
            this.energyCapacity = capacity;
            return this;
        }
        throw new IllegalStateException("You cannot modify the capacity after the Item was registered.");
    }

    @Nonnull
    public final AMachine setEnergyConsumption(int energyConsumption) {
        Preconditions.checkArgument((energyConsumption > 0 ? 1 : 0) != 0, (Object)"Energy consumption must be greater than 0");
        if (this.getState() == ItemState.UNREGISTERED) {
            this.energyConsumption = energyConsumption;
            return this;
        }
        throw new IllegalStateException("You cannot modify the energy consumption after the Item was registered.");
    }

    protected abstract void registerDefaultRecipes();

    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (MachineRecipe recipe : this.recipes) {
            int length = Math.max(recipe.getInput().length, recipe.getOutput().length);
            ItemStack[] inputs = Arrays.copyOf(recipe.getInput(), length);
            ItemStack[] outputs = Arrays.copyOf(recipe.getOutput(), length);
            for (int i = 0; i < length; ++i) {
                list.add(inputs[i]);
                list.add(outputs[i]);
            }
        }
        return list;
    }

    @ParametersAreNonnullByDefault
    protected void registerRecipe(int ticks, ItemStack[] inputs, ItemStack[] outputs) {
        this.recipes.add(new MachineRecipe(ticks, inputs, outputs));
    }

    @ParametersAreNonnullByDefault
    protected void registerRecipe(int ticks, ItemStack[] inputs, ItemStack outputs) {
        this.recipes.add(new SingleOutputMachineRecipe(ticks, inputs, outputs));
    }

    @ParametersAreNonnullByDefault
    protected void registerRecipe(int ticks, ItemStack input, ItemStack output) {
        this.recipes.add(new SingleMachineRecipe(ticks, input, output));
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void tick(Block b, BlockMenu menu) {
        BlockMenu inv = BlockStorage.getInventory((Block)b);
        CraftingOperation currentOperation = (CraftingOperation)this.processor.getOperation(b);
        if (currentOperation != null) {
            if (EnergyNetUtils.takeCharge(this, b.getLocation(), this.getEnergyConsumption())) {
                if (!currentOperation.isFinished()) {
                    this.processor.updateProgressBar(inv, 22, (MachineOperation)currentOperation);
                    currentOperation.addProgress(1);
                } else {
                    inv.replaceExistingItem(22, NOT_WORKING_ITEM);
                    for (ItemStack output : currentOperation.getResults()) {
                        inv.pushItem(output.clone(), this.getOutputSlots());
                    }
                    this.processor.endOperation(b);
                }
            }
        } else {
            MachineRecipe next = this.findNextRecipe(inv);
            if (next != null) {
                this.processor.startOperation(b, (MachineOperation)new CraftingOperation(next.toSf()));
            }
        }
    }

    @Nullable
    protected MachineRecipe findNextRecipe(@Nonnull BlockMenu inv) {
        HashMap<Integer, ItemStackWrapper> inventory = new HashMap<Integer, ItemStackWrapper>();
        for (int slot : this.getInputSlots()) {
            ItemStack itemStack = inv.getItemInSlot(slot);
            if (itemStack == null) continue;
            inventory.put(slot, ItemStackWrapper.wrap((ItemStack)itemStack));
        }
        HashMap<Integer, Integer> found = new HashMap<Integer, Integer>();
        for (MachineRecipe recipe : this.recipes) {
            block2: for (ItemStack input : recipe.getInput()) {
                for (int slot : this.getInputSlots()) {
                    if (!SlimefunUtils.isItemSimilar((ItemStack)((ItemStack)inventory.get(slot)), (ItemStack)input, (boolean)false)) continue;
                    found.put(slot, input.getAmount());
                    continue block2;
                }
            }
            if (found.size() == recipe.getInput().length) {
                if (!InvUtils.fitAll((Inventory)inv.toInventory(), (ItemStack[])recipe.getOutput(), (int[])this.getOutputSlots())) {
                    return null;
                }
                for (Map.Entry entry : found.entrySet()) {
                    inv.consumeItem(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue());
                }
                return recipe;
            }
            found.clear();
        }
        return null;
    }

    public void register(@Nonnull SlimefunAddon addon) {
        Preconditions.checkArgument((this.energyCapacity > 0 ? 1 : 0) != 0, (Object)"Energy capacity must be greater than 0");
        Preconditions.checkArgument((this.energyConsumption > 0 ? 1 : 0) != 0, (Object)"Energy consumption must be greater than 0");
        Preconditions.checkArgument((this.energyConsumption <= this.energyCapacity ? 1 : 0) != 0, (Object)"Energy consumption must be less than or equal to the energy capacity");
        super.register(addon);
        this.registerDefaultRecipes();
    }

    public int getEnergyConsumption() {
        return this.energyConsumption;
    }
}

