/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.ultimategenerators2.implementation.items.generators.modular.ender_crystal;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.operations.FuelOperation;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import net.guizhanss.ultimategenerators2.core.recipes.MachineFuel;
import net.guizhanss.ultimategenerators2.implementation.UGItems;
import net.guizhanss.ultimategenerators2.implementation.items.abstracts.AGenerator;
import net.guizhanss.ultimategenerators2.utils.LocationUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EntityType;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class EnderCrystalGenerator
extends AGenerator {
    private static final Map<BlockPosition, Integer> CRYSTAL_COUNT = new HashMap<BlockPosition, Integer>();
    private static final int INFO_SLOT = 18;

    @ParametersAreNonnullByDefault
    protected EnderCrystalGenerator(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    protected void setup(@Nonnull BlockMenuPreset preset) {
        super.setup(preset);
        preset.addItem(18, NOT_WORKING_ITEM, ChestMenuUtils.getEmptyClickHandler());
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.END_CRYSTAL);
    }

    @Override
    protected void registerDefaultFuelTypes() {
        this.registerFuel(7200, (ItemStack)UGItems.RUNE_COMPLEX_ENDER, (ItemStack)SlimefunItems.STONE_CHUNK);
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void onPlace(BlockPlaceEvent e, Block b) {
        super.onPlace(e, b);
        BlockPosition loc = new BlockPosition(b);
        CRYSTAL_COUNT.put(loc, 0);
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void onBreak(BlockBreakEvent e, BlockMenu menu) {
        super.onBreak(e, menu);
        Location loc = menu.getLocation();
        CRYSTAL_COUNT.remove(new BlockPosition(loc));
        loc.getWorld().getNearbyEntities(loc, 4.0, 4.0, 4.0, entity -> entity.getType() == EntityType.ENDER_CRYSTAL).stream().map(EnderCrystal.class::cast).forEachOrdered(crystal -> {
            try {
                if (!crystal.isShowingBottom() && crystal.hasMetadata("UG2_ENHANCED_ENDER_CRYSTAL") && crystal.getBeamTarget().getBlock().getLocation().distance(LocationUtils.getBlockCenter(loc.add(0.0, -1.0, 0.0))) == 0.0) {
                    crystal.setBeamTarget(null);
                }
            }
            catch (Exception ex) {
                crystal.setBeamTarget(null);
            }
        });
    }

    public int getEnergyProduction(BlockPosition pos) {
        return super.getEnergyProduction() * CRYSTAL_COUNT.computeIfAbsent(pos, k -> 0);
    }

    @Override
    @ParametersAreNonnullByDefault
    public int getGeneratedOutput(Location l, Config data) {
        BlockMenu inv = BlockStorage.getInventory((Location)l);
        BlockPosition pos = new BlockPosition(l);
        FuelOperation operation = (FuelOperation)this.processor.getOperation(l);
        if (operation != null) {
            if (!operation.isFinished()) {
                this.processor.updateProgressBar(inv, 22, (MachineOperation)operation);
                if (this.isChargeable()) {
                    int charge = this.getCharge(l, data);
                    if (this.getCapacity() - charge >= this.getEnergyProduction(pos)) {
                        operation.addProgress(1);
                        return this.getEnergyProduction(pos);
                    }
                    return 0;
                }
                operation.addProgress(1);
                return this.getEnergyProduction(pos);
            }
            inv.replaceExistingItem(22, NOT_WORKING_ITEM);
            this.processor.endOperation(l);
            return 0;
        }
        if (CRYSTAL_COUNT.get(pos) > 0) {
            HashMap<Integer, Integer> found = new HashMap<Integer, Integer>();
            MachineFuel fuel = this.findRecipe(inv, found);
            if (fuel != null) {
                for (Map.Entry entry : found.entrySet()) {
                    inv.consumeItem(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue());
                }
                this.processor.startOperation(l, (MachineOperation)new FuelOperation(fuel.toSf()));
            }
            return 0;
        }
        return 0;
    }
}

