/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.ultimategenerators2.implementation.items.abstracts;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetProvider;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.operations.FuelOperation;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import net.guizhanss.ultimategenerators2.core.recipes.MachineFuel;
import net.guizhanss.ultimategenerators2.implementation.UGItems;
import net.guizhanss.ultimategenerators2.implementation.items.abstracts.AHopper;
import net.guizhanss.ultimategenerators2.libs.guizhanlib.minecraft.utils.ChatUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public abstract class AGenerator
extends AHopper
implements EnergyNetProvider,
MachineProcessHolder<FuelOperation> {
    protected final Set<MachineFuel> fuelTypes = new HashSet<MachineFuel>();
    protected final MachineProcessor<FuelOperation> processor = new MachineProcessor((MachineProcessHolder)this);
    private int energyCapacity = -1;
    private int energyProduction = -1;

    @ParametersAreNonnullByDefault
    protected AGenerator(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    public abstract ItemStack getProgressBar();

    @Nonnull
    public MachineProcessor<FuelOperation> getMachineProcessor() {
        return this.processor;
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void onBreak(BlockBreakEvent e, BlockMenu menu) {
        super.onBreak(e, menu);
        this.processor.endOperation(menu.getLocation());
    }

    protected abstract void registerDefaultFuelTypes();

    protected void registerFuel(int ticks, @Nonnull ItemStack fuel) {
        this.registerFuel(ticks, fuel, null);
    }

    protected void registerFuel(int ticks, @Nonnull ItemStack fuel, @Nullable ItemStack output) {
        this.fuelTypes.add(new MachineFuel(ticks, fuel, output));
    }

    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (MachineFuel fuel : this.fuelTypes) {
            CustomItemStack item = new CustomItemStack(fuel.getInput().clone(), im -> {
                ArrayList<CallSite> lore = new ArrayList<CallSite>(List.of("&8\u21e8 &7\u23f2 " + NumberUtils.getTimeLeft((int)(fuel.getTicks() / 2)), "&8\u21e8 &e\u26a1 &7" + this.getEnergyProduction() + " J/t", "&8\u21e8 &e\u26a1 &7" + NumberUtils.getCompactDouble((double)((double)fuel.getTicks() * (double)this.getEnergyProduction())) + " J in total"));
                im.setLore(ChatUtil.color(lore));
            });
            list.add((ItemStack)item);
        }
        return list;
    }

    public int getCapacity() {
        return this.energyCapacity;
    }

    public final AGenerator setCapacity(int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"Capacity must be greater than 0");
        if (this.getState() == ItemState.UNREGISTERED) {
            this.energyCapacity = capacity;
            return this;
        }
        throw new IllegalStateException("You cannot modify the capacity after the Item was registered.");
    }

    public final AGenerator setEnergyProduction(int energyProduction) {
        Preconditions.checkArgument((energyProduction > 0 ? 1 : 0) != 0, (Object)"Energy production must be greater than 0");
        if (this.getState() == ItemState.UNREGISTERED) {
            this.energyProduction = energyProduction;
            return this;
        }
        throw new IllegalStateException("You cannot modify the energy production after the Item was registered.");
    }

    @ParametersAreNonnullByDefault
    public int getGeneratedOutput(Location l, Config data) {
        BlockMenu inv = BlockStorage.getInventory((Location)l);
        FuelOperation operation = (FuelOperation)this.processor.getOperation(l);
        if (operation != null) {
            if (!operation.isFinished()) {
                this.processor.updateProgressBar(inv, 22, (MachineOperation)operation);
                if (this.isChargeable()) {
                    int charge = this.getCharge(l, data);
                    if (this.getCapacity() - charge >= this.getEnergyProduction()) {
                        operation.addProgress(1);
                        return this.getEnergyProduction();
                    }
                    return 0;
                }
                operation.addProgress(1);
                return this.getEnergyProduction();
            }
            ItemStack fuel = operation.getIngredient();
            if (this.isBucket(fuel)) {
                inv.pushItem(new ItemStack(Material.BUCKET), this.getOutputSlots());
            }
            inv.replaceExistingItem(22, NOT_WORKING_ITEM);
            this.processor.endOperation(l);
            return 0;
        }
        HashMap<Integer, Integer> found = new HashMap<Integer, Integer>();
        MachineFuel fuel = this.findRecipe(inv, found);
        if (fuel != null) {
            for (Map.Entry entry : found.entrySet()) {
                inv.consumeItem(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue());
            }
            this.processor.startOperation(l, (MachineOperation)new FuelOperation(fuel.toSf()));
        }
        return 0;
    }

    private boolean isBucket(@Nullable ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemStackWrapper wrapper = ItemStackWrapper.wrap((ItemStack)item);
        return item.getType() == Material.LAVA_BUCKET || SlimefunUtils.isItemSimilar((ItemStack)wrapper, (ItemStack)SlimefunItems.FUEL_BUCKET, (boolean)false) || SlimefunUtils.isItemSimilar((ItemStack)wrapper, (ItemStack)SlimefunItems.OIL_BUCKET, (boolean)false) || SlimefunUtils.isItemSimilar((ItemStack)wrapper, (ItemStack)UGItems.BIOFUEL_BUCKET, (boolean)false) || SlimefunUtils.isItemSimilar((ItemStack)wrapper, (ItemStack)UGItems.BIOMASS_BUCKET, (boolean)false) || SlimefunUtils.isItemSimilar((ItemStack)wrapper, (ItemStack)UGItems.DIESEL_BUCKET, (boolean)false);
    }

    @Nullable
    @ParametersAreNonnullByDefault
    protected MachineFuel findRecipe(BlockMenu menu, Map<Integer, Integer> found) {
        for (MachineFuel fuel : this.fuelTypes) {
            for (int slot : this.getInputSlots()) {
                if (!fuel.test(menu.getItemInSlot(slot))) continue;
                found.put(slot, fuel.getInput().getAmount());
                return fuel;
            }
        }
        return null;
    }

    public void register(@Nonnull SlimefunAddon addon) {
        Preconditions.checkArgument((this.energyCapacity > 0 ? 1 : 0) != 0, (Object)"Energy capacity must be greater than 0");
        Preconditions.checkArgument((this.energyProduction > 0 ? 1 : 0) != 0, (Object)"Energy production must be greater than 0");
        Preconditions.checkArgument((this.energyCapacity >= this.energyProduction ? 1 : 0) != 0, (Object)"Energy capacity must be greater than or equal to energy production");
        super.register(addon);
        this.registerDefaultFuelTypes();
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void tick(Block block, BlockMenu menu) {
    }

    public int getEnergyProduction() {
        return this.energyProduction;
    }
}

