/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.ultimategenerators2.core.services;

import net.guizhanss.ultimategenerators2.UltimateGenerators2;
import net.guizhanss.ultimategenerators2.libs.guizhanlib.slimefun.addon.AddonConfig;

public final class ConfigurationService {
    private final AddonConfig config;
    private boolean autoUpdate;
    private boolean debug;
    private String lang;
    private int glassElectricityTransmitterCraftAmount;
    private int enderCrystalGeneratorEnergyPerCrystal;

    public ConfigurationService(UltimateGenerators2 plugin) {
        this.config = new AddonConfig(plugin, "config.yml");
        this.reload();
    }

    public void reload() {
        this.config.reload();
        this.config.addMissingKeys();
        this.autoUpdate = this.config.getBoolean("auto-update", true);
        this.debug = this.config.getBoolean("debug", false);
        this.lang = this.config.getString("lang", "en");
        this.glassElectricityTransmitterCraftAmount = this.config.getInt("glass-electricity-transmitter.craft-amount", 12);
        this.enderCrystalGeneratorEnergyPerCrystal = this.config.getInt("ender-crystal-generator.energy-per-crystal", 128);
        this.config.save();
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getLang() {
        return this.lang;
    }

    public int getGlassElectricityTransmitterCraftAmount() {
        return this.glassElectricityTransmitterCraftAmount;
    }

    public int getEnderCrystalGeneratorEnergyPerCrystal() {
        return this.enderCrystalGeneratorEnergyPerCrystal;
    }
}

